/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

// ActionBase.cpp: implementation of the CActionBase class.

#include "stdafx.h"
#include "Undo/ActionBase.h"
#include "Undo/IActionTarget.h"
#include "Undo/IActionManager.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CActionBase::CActionBase(IActionTarget* aTarget, bool notify)
	 : m_actionTarget(aTarget),
	   m_autoNotify(notify),
	   m_undone(false),
	   m_undo_stack(true)
{
}

IActionTarget* CActionBase::GetActionTarget() const
{
	return m_actionTarget;
}

void CActionBase::SetActionTarget(IActionTarget* pTarget)
{
	m_actionTarget = pTarget;
}

// do the operation
void CActionBase::Do()
{
	if(m_autoNotify){
		GetActionTarget()->GetActionManager()->SetLastAction(this);
	}
}
