/********************************************************************/
/* Copyright (c) 2017 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// MeshTool.cpp: MGMeshTool NX̃Cve[V

#include "stdafx.h"
#include "Tl2/TL2Triangles.h"
#include "Tl2/TL2Triangle.h"
#include "Tl2/TL2Face.h"
#include "fugenDoc.h"
#include "MeshCmd/MeshTool.h"
#include "GLMeshFromObjDlg.h"
#include "fugenView.h"
#include "IO/GLFileManager.h"
#include "IO/GLFileExporter.h"
#include "GLFileDialog.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

MGMeshTool::MGMeshTool(fugenDoc* pDoc)
:MGSelectState(pDoc, ID_MESH, MGSelectState::MULTIPLE_SELECT, mgAll_2Manifold){
	CGLMeshFromObjDlg* dialog=attachModelessDialogue<CGLMeshFromObjDlg>(this);
}

MGCommandBase* MGMeshTool::initial_clone(fugenDoc* pDoc) const{
	return new MGMeshTool(pDoc);
}

bool MGMeshTool::initiate_tool(){
	MGSelectState::initiate_tool();

	m_target = select_from_current_objects(mgAll_2Manifold);
	m_target.remove(mgAll_Plane);
	m_target.setNoDisplay();

	CreateParamDlg();
	if(!m_target.empty()){
		// _CAO̓͑҂ԂƂȂB
		UpdateUI();
	}else{
		// I҂ԂƂȂB
		// ŏ̃bZ[W
		CGLMeshFromObjDlg& dialog = *getMeshFromObjDlg();
		dialog.ShowWindow(SW_HIDE);
		SetStatusMessage(IDS_PROMPT_SURFACE);
	}

	// R}hs
	return false;
}

bool MGMeshTool::terminate_tool(bool cancel){
	m_target.setDisplay();
	set_current_object(m_target);

	// check post-condition
	return MGSelectState::terminate_tool(cancel);
}

// Compiles OpenGL's display list of temporary objects for each
//standard views.
void MGMeshTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pSView){
	CGLMeshFromObjDlg* dialogP = getMeshFromObjDlg();
	// _CAO\O͉Ȃ
	if(!dialogP || !::IsWindow(*dialogP)){
		return;
	}
	
	CGLMeshFromObjDlg& dialog = *dialogP;
	// Ώۂ̃{[`悷
	size_t n = m_vecStl.size();
	GLenum pmode=GL_LINE;
	MGColor::get_instance(MGColor::SpringGreen).exec(sgl);

	const MGCL::VIEWMODE vmode = dialog.GetDisplay().GetViewMode();
	if(vmode == MGCL::SHADING || vmode == MGCL::WIRE_AND_SHADING){
		//CgON
		mgLightModeSwitcher switcher(sgl, mgGLSL::Shading);
		for(size_t i = 0; i < n; i++)
			sgl.drawSTL(*m_vecStl[i], mgVBO::WIRE,GL_FILL);
	}
	if(vmode == MGCL::WIRE || vmode == MGCL::WIRE_AND_SHADING){
		mgLightModeSwitcher switcher(sgl, mgGLSL::NoShading);
		for(size_t i = 0; i < n; i++)
			sgl.drawSTL(*m_vecStl[i], mgVBO::WIRE,GL_LINE);
	}
}

bool MGMeshTool::OnSelected(
	fugenView*, //The fugenView pointer where point input event took place.
	MGPickObjects&, //selected objects at this selection operation.
	MGPickObjects&  //unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
){
	m_target.setDisplay();
	m_target = select_from_current_objects(mgAll_2Manifold);
	m_target.remove(mgAll_Plane);
	m_target.remove(mgAll_STL);

	if(!m_target.empty()){
		m_target.setNoDisplay();		
		UpdateUI();
	}
	return false;
}

void MGMeshTool::UpdateUI(){
	make_stl();

	// _CAOXV
	// Op`A_擾_CAÕRg[ϐɐݒ
	// ŌɃ_CAO̕\XV
	CGLMeshFromObjDlg& dialog = *getMeshFromObjDlg();
	dialog.ShowWindow(SW_SHOW);
	CGLMeshInfoDlg& info = dialog.GetInfo();
	info.SetTriangleEdit(m_vecStl);
	
	// r[XV
	draw_temporary();
}

void MGMeshTool::CreateParamDlg(){
	CGLMeshFromObjDlg& dialog = *getMeshFromObjDlg();

	// bVp[^ύX_CAO\
	dialog.Create(IDD_MESH_FROM_OBJECT);
	SetStatusMessage(IDS_PROMPT_PARAMETER);

	// bVp[^ύX_CAOɒlݒ
	mgTLInputParam tlparam;
	dialog.GetTess().GetTesselValue(tlparam);
	if(tlparam.crvTol() == -1.)//vON㏉߂ăR}hĂ΂ꂽƂ̂ݏ
		dialog.GetTess().SetTesselValue(document()->context()->tessellate_param());
}

// \MGStlIuWFNghLgɒǉAt@Cւ̕ۑs
// ̌AhLg폜
void MGMeshTool::OnMeshSave(){

	// SĂ̊gqƃGNX|[^[IuWFNg̃}bv擾
	CGLFileManager::OMap mapo;
	CGLFileManager::GetInstance().GetAllSaveHandler(mapo);

	// tB^[Agqi[p̕ϐ
	CString filter;

	// t@C_CAÕtB^[ɗp镶쐬
	const UINT exts[4] = {
		IDS_FILTER_STL_EXT,
		IDS_FILTER_OBJ_EXT,
		IDS_FILTER_NAS_EXT,
		IDS_FILTER_UNV_EXT,
	};

	int nMaxCustFilter = 0;
	const size_t nExt = 4;
	for(size_t j = 0; j < nExt; ++j){
		CString strExt;
		VERIFY(strExt.LoadString(exts[j]));
		std::map<CString, CGLFileExporter*>::iterator i = mapo.find(strExt);
		if(i != mapo.end()){
			filter += i->second->GetTypeString(); // tB^[
			filter += (TCHAR)'\0';
			filter += i->first;
			filter += (TCHAR)'\0';
			nMaxCustFilter++;
		}
	}

	// ۑp̃t@C_CAO𐶐
	CGLFileDialog dlg(FALSE);

	// tB^[Agqt@C_CAOɐݒ
	dlg.m_ofn.nMaxCustFilter = nMaxCustFilter;
	dlg.m_ofn.lpstrFilter = filter;

	// t@C_CAO\
	if(dlg.DoModal() != IDOK){
		return;
	}

	// [ۑ]̏
	CString fileName(dlg.GetPathName());
	if(dlg.GetFileExt().IsEmpty()){
		// gq͂Ȃꍇ
		// t@CpXɊgqt
		CString strExt;
		VERIFY(strExt.LoadString(exts[dlg.m_ofn.nFilterIndex - 1]));

		::PathAddExtension(
			fileName.GetBuffer(MAX_PATH), ::PathFindExtension(strExt));
		fileName.ReleaseBuffer();
	}

	// \MGStlt@C֕ۑ
	std::vector<UniqueStl>& stls = GetVecStl();
	size_t n=stls.size();
	MGGroup work;
	for(size_t i=0; i<n; i++)
		work.append( stls[i].get());// workmemeberdeleteĂ͂Ȃ

	CGLFileExporter* pHandler = CGLFileManager::GetInstance().GetExporter(fileName);
	if(pHandler)
		pHandler->Save(work);

	// workmemeberdeleteĂ͂Ȃ
	MGGroup::MYLIST::iterator i=work.begin(), iend=work.end();
	for(; i!=iend; i++){
		i->release();
	}
}

//Make stl data in m_vecStl from m_target.
void MGMeshTool::make_stl(){
	CGLMeshFromObjDlg& dialog = *getMeshFromObjDlg();

	// _CAOp[^擾
	mgTLInputParam tlparam;
	dialog.GetTess().GetTesselValue(tlparam);

	m_vecStl.clear();
	double cerr=tlparam.crvTol();
	double serr=tlparam.surfTol();
	double elen=tlparam.max_edge_len();
	MGDrawParam dpara(cerr,serr,elen);
	double error=cerr>=serr ? cerr:serr;
	size_t n=m_target.size();
	for(size_t i=0; i<n; i++){
		const MGObject& obji=*(m_target[i].top_object());
		const MGFSurface* f=obji.fsurface();
		if(f){
			mgTL2Triangles tris(MGCL::XYZ,f->get_surface_pointer());//Tri of (u,v) value data.
			mgTL2Face face(*f,cerr,serr,elen);
			face.tessellate(tris);
			m_vecStl.emplace_back(new MGStl(error,tris));
		}else{
			const MGShell* shel=obji.shell();
			std::vector<UniqueLBRep> boundaries;//Container of the boundary data.
			std::vector< std::vector<SHLL_COM_EDGES> > polylines;
			set_up_shell_shade(*shel,dpara,boundaries,polylines);//shade

			MGComplex::const_pcellItr i=shel->pcell_begin();
			size_t nfaces=shel->number_of_faces();
			for(size_t j=0; j<nfaces; j++,i++){
				const MGFace& fj=*(shel->face(i));
				mgTL2Face face(dpara,fj,&(polylines[j]));
				mgTL2Triangles tris(MGCL::XYZ,fj.surface());
				face.tessellate(tris);	
				m_vecStl.emplace_back(new MGStl(error,tris));
			}

		}
	}
}
