/********************************************************************/
/* Copyright (c) 2017 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// GaussDlg.h: CGaussDlg NX̃C^[tFCX

#if !defined(AFX_GAUSSDLG_H__FE777497_2455_4C0B_982A_32B417F73749__INCLUDED_)
#define AFX_GAUSSDLG_H__FE777497_2455_4C0B_982A_32B417F73749__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mgModelessDialogue.h"

class MGEvalSurfGaussTool;

class CGaussDlg : public mgModelessDialogue{
	friend class MGEvalSurfGaussTool;

	TRIVERTEX m_vert[5];
	GRADIENT_RECT m_gr[4];
	BOOL m_bModified;

// _CAO f[^
	//{{AFX_DATA(CSrfCurvaDlg)
	double	m_dMin;
	double	m_dMax;
	CString	m_strMean;
	//}}AFX_DATA

public:

	//Dialogue id=IDD_SRFCURVA_DLG
	CGaussDlg(MGEvalSurfGaussTool* tool);

	int GetCurvaKindfromDialog() const;
	double GetRangeMax() const{ return m_dMax;}
	double GetRangeMin() const{ return m_dMin;}

	BOOL IsModified() const{ return m_bModified;}
	void SetModifiedFlag(BOOL bModified = TRUE){ m_bModified = bModified;}
	MGEvalSurfGaussTool* getEvalSurfGaussTool();

	MGCL::SURFACE_CURVATURE_KIND GetCurvaKind() const;

	virtual void OnOK();
	
// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CGaussDlg)
protected:
	virtual BOOL OnInitDialog();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

// Cve[V
protected:
	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CGaussDlg)
	afx_msg void OnPaint();
	afx_msg void OnUpdateEditCtrl();
	afx_msg void OnSelchangeSrfcurvaCombo();
	afx_msg void UpdateView();
	afx_msg void ResetAutoRange();
	afx_msg void ResetMinMaxRange();
	//}}AFX_MSG

private:
	void UpdateGradientArea();

	DECLARE_MESSAGE_MAP()
};

#endif // !defined(AFX_GAUSSDLG_H__FE777497_2455_4C0B_982A_32B417F73749__INCLUDED_)
