/********************************************************************/
/* Copyright (c) 2017 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
#pragma once

#include "GLMeshTessDlg.h"
#include "GLMeshDisplayDlg.h"
#include "GLMeshSaveDlg.h"
#include "GLMeshInfoDlg.h"
#include "mgModelessDialogue.h"

class MGMeshTool;

// CGLMeshFromObjDlg _CAO

class CGLMeshFromObjDlg : public mgModelessDialogue{
	DECLARE_DYNAMIC(CGLMeshFromObjDlg)

	CTabCtrl m_tab;
	CGLMeshTessDlg m_tess;
	CGLMeshDisplayDlg m_disp;
	CGLMeshSaveDlg m_save;
	CGLMeshInfoDlg m_info;

public:
	CGLMeshFromObjDlg(MGMeshTool* tool);   // WRXgN^
	virtual ~CGLMeshFromObjDlg()=default;

	/// q_CAOւ̒ڃANZX
	CGLMeshTessDlg& GetTess(){ return m_tess; }
	CGLMeshDisplayDlg& GetDisplay(){ return m_disp; }
	CGLMeshSaveDlg& GetSave(){ return m_save; }
	CGLMeshInfoDlg& GetInfo(){ return m_info; }
	MGMeshTool* getMeshFromObjDlgPointer();

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	virtual BOOL OnInitDialog();
	virtual void OnOK();

	afx_msg void OnTcnSelchangeMeshCreateTab(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg LRESULT OnFacetParamChanged(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDisplayStyleChanged(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnMeshSave(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
};
