/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// TransShear.h: MGTransShearTool NX̃C^[tFCX
#pragma once
#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
#include "Common/LocateState.h"

// class MGTransShearTool
//
// Scales objects in one dimension.
// The objects are expanded or contracted in the single direction specified,
// without expanding the objects in the other directions.
class MGTransShearTool : public MGCommandStateOwner{
	friend class MGTransShearIPoint;

public:
	explicit MGTransShearTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

};

// class MGTransShearSObj
// 
// IuWFNg̑I
class MGTransShearSObj : public MGSelectState{
public:
	MGTransShearSObj(MGTransShearTool* owner);

	MGTransShearTool* state_owner(){
		return static_cast<MGTransShearTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);
};

// class MGTransShearIPoint
// 
// shaering ̊px߂邽߂̎QƓ_
class MGTransShearIPoint : public MGLocateState{
public:
	MGTransShearIPoint(MGTransShearTool* owner);

	bool IsCopyMode()const{return m_bCopy;};
	virtual bool OnKeyDown(fugenView* window, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);

private:

	MGTransf m_transf;
	bool m_bCopy;

	bool calculate();
	void calc_transform(const MGPosition& ref2);
	void ToggleCopyMode(){m_bCopy = !m_bCopy;};
	void prompt_message() const;
};
