/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// TransMirror.h: MGTransMirrorTool NX̃C^[tFCX

#if !defined(AFX_TRANSMIRROR_H__3D6C3BD3_E865_49F6_AB92_2F3C707E8161__INCLUDED_)
#define AFX_TRANSMIRROR_H__3D6C3BD3_E865_49F6_AB92_2F3C707E8161__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mg/PickObjects.h"
#include "Common/CommandStateOwner.h"
#include "Common/LocateState.h"
#include "Common/SelectState.h"

// class MGTransMirrorTool
//
// Mirrors objects.
class MGTransMirrorTool : public MGCommandStateOwner{
	friend class MGTransMirrorSObj;
	friend class MGTransMirrorIPoint;

public:
	explicit MGTransMirrorTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);

	bool IsCopyMode() const{ return m_copy;}
	void ToggleCopyMode(){ m_copy ^= true;}
	void calc_transform(fugenView* pView, const MGPosition& ref);

private:
	bool make_model(fugenView* pView);

	//set the cloned initial objects.
	void set_initial_object();

	MGPickObjects          m_obj; // IWĩIuWFNg
	MGTransf   m_transf; // ϊ\IuWFNg
	bool       m_copy;  // ŏIIɃRs[邩ǂ

};

//Object selection class.
class MGTransMirrorSObj : public MGSelectState{
public:
	MGTransMirrorSObj(MGCommandStateOwner* owner);
	
	MGTransMirrorTool* state_owner(){
		return static_cast<MGTransMirrorTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);

private:
};

//Weight data for the smoothing input class.
class MGTransMirrorIPoint : public MGLocateState{
public:
	MGTransMirrorIPoint(MGCommandStateOwner* owner);
	MGTransMirrorTool* state_owner(){
		return static_cast<MGTransMirrorTool*>(get_owner_command());
	}
	const MGTransMirrorTool* state_owner() const{
		return static_cast<const MGTransMirrorTool*>(get_owner_command());
	}

	virtual bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);

	/////////////////functions for draw_temporary()////////////
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);

private:
	void prompt_message() const;
};

#endif // !defined(AFX_TRANSMIRROR_H__3D6C3BD3_E865_49F6_AB92_2F3C707E8161__INCLUDED_)
