/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// TransCopy.h: MGTransCopyTool NX̃C^[tFCX

#if !defined(AFX_COPYTOOL_H__18CB1904_0338_45DE_9FA4_58F4006A627B__INCLUDED_)
#define AFX_COPYTOOL_H__18CB1904_0338_45DE_9FA4_58F4006A627B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mg/PickObjects.h"
#include "Common/CommandStateOwner.h"
#include "Common/LocateState.h"
#include "Common/SelectState.h"

// class MGTransCopyTool
//
// Mirrors objects.
class MGTransCopyTool : public MGCommandStateOwner{
public:
	explicit MGTransCopyTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);

private:
	bool copy_identical();

	friend class MGTransCopySObj;
	friend class MGTransCopyIPoint;
};

//Object selection class for MGTransCopyTool and MGTransMoveTool
class MGTransCopySObj : public MGSelectState{
public:
	MGTransCopySObj(MGCommandStateOwner* owner);
	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);

private:
};

// class MGTransCopyIPoint for MGTransCopyTool and MGTransMoveTool
//
// ʒu̎w
class MGTransCopyIPoint : public MGLocateState{
public:
	MGTransCopyIPoint(MGCommandStateOwner* owner,const MGPickObjects& targets);
	bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);
	bool OnLocated(const MGLocateInfo& info);
	void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);
	void prompt_message() const;

private:
	void calc_transform(const MGPosition& ref);
	bool make_model();

	MGPickObjects m_objs; // Target Objects
	MGVector m_move; // translation vector.
	bool m_bVert; // track is vertical to the construction plane.
};
#endif // !defined(AFX_COPYTOOL_H__18CB1904_0338_45DE_9FA4_58F4006A627B__INCLUDED_)
