/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno    @@     */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file PropertyTool.cpp
 * @brief PropertyTool.h ̎
 */
#include "stdafx.h"
#include "GLPropPanel.h"
#include "fugenView.h"
#include "ToolCmd/PropertyTool.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/// RXgN^[
/// @param[in] pDoc R}hΏۃhLg
/// @param[in] nCmdID R}h ID
/// @param[in] nIDD ŏɊJĂvpeB[y[W̃\[X ID
MGPropertyTool::MGPropertyTool(fugenDoc* pDoc, UINT nCmdID, UINT nIDD)
: MGCommandBase(pDoc, nCmdID), m_nIDD(nIDD){
}

MGCommandBase* MGPropertyTool::initial_clone(fugenDoc* pDoc) const{
	return CreatePropertyTool(pDoc, m_nIDD);
}

bool MGPropertyTool::initiate_tool(){
	MGCommandBase::initiate_tool();
	SetStatusMessage(_T(""));

	fugenDoc* pDoc = document();
	CGLPropDialog panel(pDoc, 0, m_nIDD);
	UINT id = IDOK == panel.DoModal() ? 1:3;
	return OnCommandEnd(id);
}

// t[֐

MGCommandBase* CreatePropertyTool(fugenDoc* pDoc, UINT nCmdID){
	// ŏɊJĂvpeB[y[W̃\[X ID
	UINT nIDD = 0;

	switch(nCmdID){
	case ID_PARAM_TOLERANCE:
	case ID_CONTEXT_TOLERANCE:// VXegX
		nIDD = IDD_PROP_UNIT;
		break;
	case ID_PARAM_TESSELLATION:
	case ID_CONTEXT_TESSPARAM:
		nIDD = IDD_PROP_MESH;
		break;
	case ID_CONTEXT_COLOR:
		nIDD = IDD_PROP_COLOR;
		break;
	case ID_CPLANE_GRID:
		nIDD = IDD_PROP_CPLANE;
		break;
	}

	return new MGPropertyTool(pDoc, nCmdID, nIDD);
}
