/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfUntrim.h
 * @brief MGSurfUntrimTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFUNTRIM_H__DA6D8356_5CE4_4AE3_BF75_CDBEF0D6195E__INCLUDED_)
#define AFX_SURFUNTRIM_H__DA6D8356_5CE4_4AE3_BF75_CDBEF0D6195E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"
#include "mg/PickObjectFB.h"

/// @class MGSurfUntrimTool SurfUntrim.h SurfCmd/SurfUntrim.h
/// 
/// MGFacẽoE_sbNāAMGLoop菜悤
/// MGFaceƒuƂR}hNXB
class MGSurfUntrimTool : public MGSelectState{
public:
	MGSurfUntrimTool(fugenDoc* pDoc, UINT nCmdID, bool bKeep);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

private:
	bool calculate(MGGelPosition& pobj);
	void prompt_message() const;

	bool m_bKeep; ///< gJ[uc
};

// t@Ng[p
MGCommandBase* CreateSurfUntrimTool(fugenDoc* pDoc, UINT nCmdId);

#endif // !defined(AFX_SURFUNTRIM_H__DA6D8356_5CE4_4AE3_BF75_CDBEF0D6195E__INCLUDED_)
