/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file SurfSweepRibbon.h
 * @brief MGSurfSweepRibbonTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFSWEEPRIBBON_H__0EA03C3A_E75D_4EFF_AB29_D9B364D9C9DF__INCLUDED_)
#define AFX_SURFSWEEPRIBBON_H__0EA03C3A_E75D_4EFF_AB29_D9B364D9C9DF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
#include "Common/LocateState.h"

/// @class MGSurfSweepRibbonTool SurfSweepRibbon.h SurfCmd/SurfSweepRibbon.h
///
/// яXC[vR}h
class MGSurfSweepRibbonTool : public MGCommandStateOwner{
public:
	explicit MGSurfSweepRibbonTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

private:
	bool calculate();

	const MGCurve* m_curve;
	std::vector<UniqueCurve> m_perims;

	friend class MGSurfSweepRibbonSCurve;
	friend class MGSurfSweepRibbonIPoint;
};

/// @class MGSurfSweepRibbonSCurve
///
/// ŋȐIB
class MGSurfSweepRibbonSCurve : public MGSelectState{
public:
	explicit MGSurfSweepRibbonSCurve(MGSurfSweepRibbonTool* owner);

	MGSurfSweepRibbonTool* state_owner(){
		return static_cast<MGSurfSweepRibbonTool*>(get_owner_command());
	}
	const MGSurfSweepRibbonTool* state_owner() const{
		return static_cast<const MGSurfSweepRibbonTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* pView,
		MGPickObjects& objs,
		MGPickObjects& unobjs
		);

private:
	void prompt_message() const;
};

/// @class MGSurfSweepRibbonIPoint
///
/// ItZbgʒu肷B
class MGSurfSweepRibbonIPoint : public MGLocateState{
public:
	explicit MGSurfSweepRibbonIPoint(MGSurfSweepRibbonTool* owner);

	MGSurfSweepRibbonTool* state_owner(){
		return static_cast<MGSurfSweepRibbonTool*>(get_owner_command());
	}
	const MGSurfSweepRibbonTool* state_owner() const{
		return static_cast<const MGSurfSweepRibbonTool*>(get_owner_command());
	}

	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);

private:
	void prompt_message() const;
};

#endif // !defined(AFX_SURFSWEEPRIBBON_H__0EA03C3A_E75D_4EFF_AB29_D9B364D9C9DF__INCLUDED_)
