/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfSweepAlongCurveTool.cpp
 * @brief MGSurfSweepAlongCurveTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "SurfCmd/SurfSweepAlongCurveTool.h"
#include "Calc/surface.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGSurfSweepAlongCurveTool

MGSurfSweepAlongCurveTool::MGSurfSweepAlongCurveTool(fugenDoc* pDoc)
	 : MGSelectState(
		 pDoc,
		 ID_SURFACE_EXTRUDE_ALONG_CURVE,
		 MGSelectState::SINGLE_SELECT,
		 mgAll_Curve)
{
}

MGCommandBase* MGSurfSweepAlongCurveTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGSurfSweepAlongCurveTool(pDoc);
}

bool MGSurfSweepAlongCurveTool::initiate_tool(){
	MGSelectState::initiate_tool();
	clear_pick_object();
	SetStatusMessage(IDS_PROMPT_SWEEP_CURVE);
	return false;
}

bool MGSurfSweepAlongCurveTool::OnCommandCanceled(UINT nIDS){
	clear_pick_object();
	return MGSelectState::OnCommandCanceled(nIDS);
}

bool MGSurfSweepAlongCurveTool::OnCommandEnd(
	UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
	bool erase_temporary_display
){
	if(m_shape_curve.is_null() || m_path_curve.is_null()){
		// ݂ȂLZ
		return OnCommandCanceled(1);
	}

	SetStatusMessage(IDS_PROMPT_COMPUTE);
	CWaitCursor sandglass;

	if(m_shape_curve == m_path_curve){
		// failed
		return OnCommandCanceled(1);
	}

	const MGCurve* shape = dynamic_cast<const MGCurve*>(m_shape_curve.top_object());
	const MGCurve* path = dynamic_cast<const MGCurve*>(m_path_curve.top_object());
	std::unique_ptr<MGSurface> swept(mgcalc::create_sweep_surface(*shape, *path));
	if(!swept.get()){
		// failed
		return OnCommandCanceled(1);
	}

	MGGelPosition gelp(m_shape_curve.bottom_group(),swept.release());
	add_object_to_document(gelp);
	return MGSelectState::OnCommandEnd(1);
}

bool MGSurfSweepAlongCurveTool::OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	objs,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
){
	ASSERT(objs.size() == 1);
	ASSERT(dynamic_cast<const MGCurve*>(objs.front().top_object()));

	if(m_shape_curve.is_null()){
		m_shape_curve = objs.front();
		SetStatusMessage(IDS_PROMPT_SWEEP_RAIL);
		return false;
	}
	else{
		m_path_curve = objs.front();
	}

	// vZs
	return OnCommandEnd(1);
}

