/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file SurfSplitIso.h
 * @brief MGSurfSplitIsoTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFSPLITISO_H__A4F2CF20_D2DA_46A1_A681_0F16E802BA34__INCLUDED_)
#define AFX_SURFSPLITISO_H__A4F2CF20_D2DA_46A1_A681_0F16E802BA34__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
#include "Common/LocateOnObjects.h"

/// @class MGSurfSplitIsoTool SurfSplitIso.h SurfCmd/SurfSplitIso.h
/// 
/// f̋Ȗ (facełȂȖ) p[^C
/// R}hB
class MGSurfSplitIsoTool : public MGCommandStateOwner{
public:
	explicit MGSurfSplitIsoTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

private:
	int m_direction; ///< current parameter direction, 0:u=const, 1:v=const, 2=both.
	std::vector<MGPosition> m_uvs; ///< Located (u,v) parameter of m_surf;
	std::vector<int> m_directions; ///<[i] is the parameter direction of m_uvs[i].
	std::vector<UniqueCurve> m_plines; ///< temporary generated parameter lines.

	MGPosition m_uv; ///< current(mouse position's) surface parameter.
	std::vector<UniqueCurve> m_ulines; ///< v=const, u-parameter line for the cursor.
	std::vector<UniqueCurve> m_vlines; ///< u=const, v-parameter line for the cursor.

	friend class MGSurfSplitIsoSSurf;
	friend class MGSurfSplitIsoIPoint;
};

/// @class MGSurfSplitIsoSSurf
/// 
/// f̋ȖʂЂƂIBplane̓AEgB
class MGSurfSplitIsoSSurf : public MGSelectState{
public:
	MGSurfSplitIsoSSurf(MGSurfSplitIsoTool* owner);

	MGSurfSplitIsoTool* state_owner(){
		return static_cast<MGSurfSplitIsoTool*>(get_owner_command());
	}
	const MGSurfSplitIsoTool* state_owner() const{
		return static_cast<const MGSurfSplitIsoTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);
};

#endif // !defined(AFX_SURFSPLITISO_H__A4F2CF20_D2DA_46A1_A681_0F16E802BA34__INCLUDED_)
