/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfRuledTool.h
 * @brief MGSurfRuledTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFRULEDTOOL_H__61301FF4_AE4F_4915_A9F9_BA399D0F3EAD__INCLUDED_)
#define AFX_SURFRULEDTOOL_H__61301FF4_AE4F_4915_A9F9_BA399D0F3EAD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGSurfRuledTool SurfRuledTool.h SurfCmd/SurfRuledTool.h
///
/// DʃR}hpNX
class MGSurfRuledTool : public MGSelectState{
public:
	explicit MGSurfRuledTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

private:
	void prompt_message() const;

	MGPickObject m_curve1; ///< sbNꂽȐŁAʂ̈ӂƂȂ
	MGPickObject m_curve2; ///< sbNꂽȐBm_curve1 ̑ΕӂƂȂB
};

#endif // !defined(AFX_SURFRULEDTOOL_H__61301FF4_AE4F_4915_A9F9_BA399D0F3EAD__INCLUDED_)
