/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfRibTool.h
 * @brief MGSurfRibTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFRIBTOOL_H__B1C9A42E_E294_4CA6_8740_C421EE01E213__INCLUDED_)
#define AFX_SURFRIBTOOL_H__B1C9A42E_E294_4CA6_8740_C421EE01E213__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGSurfRibTool SurfRibTool.h SurfCmd/SurfRibTool.h
///
/// Creates a surface from a group of curves as ribs, which is the ribs of a surface.
class MGSurfRibTool : public MGSelectState{
public:
	explicit MGSurfRibTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
			//unselected_objects.size()>=1 only when the already selected objects are selected
			//when add mode is set(or when operation is done with a crtl key pressed).
		);

private:
	bool calculate();
};

#endif // !defined(AFX_SURFRIBTOOL_H__B1C9A42E_E294_4CA6_8740_C421EE01E213__INCLUDED_)
