/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfRevolutionTool.h
 * @brief MGSurfRevolutionTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFREVTOOL_H__DC3CCECB_EC1D_43CB_B78E_1354C19E2372__INCLUDED_)
#define AFX_SURFREVTOOL_H__DC3CCECB_EC1D_43CB_B78E_1354C19E2372__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mg/PickObject.h"
#include "Common/CommandStateOwner.h"
#include "Common/LocateState.h"
#include "Common/SelectState.h"

/// @class MGSurfRevolutionTool SurfRevolutionTool.h SurfCmd/SurfRevolutionTool.h
///
/// Creates a surface by revolving a curve along a rail.
class MGSurfRevolutionTool : public MGCommandStateOwner
{
public:
	explicit MGSurfRevolutionTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(UINT nIDS,bool erase_temporary_display=true);


	std::unique_ptr<MGSurface> make_model(const MGPosition& pos);
	void UpdatePreview();

private:
	MGPickObject m_curve; ///< ]ʂ̕ƂȂȐ
	std::unique_ptr<MGSurface> m_spPreview; ///< vr[f[^

	friend class MGSurfRevolutionToolSCurve;
	friend class MGSurfRevolutionToolIPoint;
};

//curve selection class.
class MGSurfRevolutionToolSCurve : public MGSelectState{
public:
	MGSurfRevolutionToolSCurve(MGCommandStateOwner* owner);
	virtual bool initiate_tool();
	MGSurfRevolutionTool* state_owner(){
		return static_cast<MGSurfRevolutionTool*>(get_owner_command());
	}
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);
};

//Weight data for the smoothing input class.
class MGSurfRevolutionToolIPoint : public MGLocateState{
public:
	MGSurfRevolutionToolIPoint(MGCommandStateOwner* owner);
	MGSurfRevolutionTool* state_owner(){
		return static_cast<MGSurfRevolutionTool*>(get_owner_command());
	}
	virtual bool OnLocated(const MGLocateInfo& linfo);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);
	void prompt_message()const;
};

#endif // !defined(AFX_SURFREVTOOL_H__DC3CCECB_EC1D_43CB_B78E_1354C19E2372__INCLUDED_)
