/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file SurfQuadGCon.h
 * @brief MGSurfQuadGConTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFQUADGCON_H__E53E2E39_EA8C_4883_9BD7_F1FB5084A7E6__INCLUDED_)
#define AFX_SURFQUADGCON_H__E53E2E39_EA8C_4883_9BD7_F1FB5084A7E6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"

/// @class MGSurfQuadGConTool SurfQuadGCon.h SurfCmd/SurfQuadGCon.h
///
/// ڑlӖʃR}h
class MGSurfQuadGConTool : public MGCommandStateOwner{
	int m_perimNum;
		//0<= && <=3 means perimeter m_inputState data(curve or tangent surface) input.

	MGPickObject m_perims[4];
	MGPickObjects m_tangentFace[4];

public:
	explicit MGSurfQuadGConTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);

private:
	bool calculate();

	friend class MGSurfQuadGConSCurve;
	friend class MGSurfQuadGConSSurf;
};

/// @class MGSurfQuadGConSCurve
///
/// ȐI state class
class MGSurfQuadGConSCurve : public MGSelectState{
public:
	MGSurfQuadGConSCurve(MGSurfQuadGConTool* owner);

	MGSurfQuadGConTool* state_owner(){
		return static_cast<MGSurfQuadGConTool*>(get_owner_command());
	}
	const MGSurfQuadGConTool* state_owner() const{
		return static_cast<const MGSurfQuadGConTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

private:
	void prompt_message() const override;
};

/// @class MGSurfQuadGConSSurf
///
/// ڑʂI state
class MGSurfQuadGConSSurf : public MGSelectState{
public:
	MGSurfQuadGConSSurf(MGSurfQuadGConTool* owner);

	MGSurfQuadGConTool* state_owner(){
		return static_cast<MGSurfQuadGConTool*>(get_owner_command());
	}
	const MGSurfQuadGConTool* state_owner() const{
		return static_cast<const MGSurfQuadGConTool*>(get_owner_command());
	}
	
	virtual bool initiate_tool();

	//ڑʃf[^͎wȂłł邽VK_RETURN ŏɎstate֐i
	virtual bool OnKeyDown(fugenView*, UINT, UINT, UINT);

	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

private:
	void prompt_message() const;
};

#endif // !defined(AFX_SURFQUADGCON_H__E53E2E39_EA8C_4883_9BD7_F1FB5084A7E6__INCLUDED_)
