/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfPlanarTool.h
 * @brief MGSurfPlanarTool NX̃C^[tFCX
 */
#if !defined(AFX_PLANARBNDFACETOOL_H__42B095D3_1268_4CB5_8AC2_F35C5B6B11FB__INCLUDED_)
#define AFX_PLANARBNDFACETOOL_H__42B095D3_1268_4CB5_8AC2_F35C5B6B11FB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGSurfPlanarTool SurfPlanarTool.h SurfCmd/SurfPlanarTool.h
///
/// Creates a planar face through planar curves that are all in the same plane.
/// If the curves partially overlap, each curve produces a separate surface.
/// If a curve is wholly within another curve then it will be treated as a hole boundary.
class MGSurfPlanarTool : public MGSelectState{
public:
	explicit MGSurfPlanarTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);

private:
	bool calculate();

	UINT m_nIDS; ///< error message
};

#endif // !defined(AFX_PLANARBNDFACETOOL_H__42B095D3_1268_4CB5_8AC2_F35C5B6B11FB__INCLUDED_)
