/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfNegate.cpp
 * @brief MGSurfNegateTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "SurfCmd/SurfNegate.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGSurfNegateTool

MGSurfNegateTool::MGSurfNegateTool(fugenDoc* pDoc)
	 : MGSelectState(
		 pDoc,
		 ID_SURFACE_NEGATE,
		 SINGLE_SELECT, // single; ł悩
		 mgAll_FSurface)
{
}

MGCommandBase* MGSurfNegateTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGSurfNegateTool(pDoc);
}

bool MGSurfNegateTool::initiate_tool(){
	MGSelectState::initiate_tool();
	if(resetCurrentObjects(mgAll_FSurface)
		&& current_objects().size() == 1){
		// ȂvZ
		return OnCommandEnd(1);
	}else{
		// ŏ̃bZ[W
		SetStatusMessage(IDS_PROMPT_SURFACE);
	}
	return false;
}

bool MGSurfNegateTool::OnCommandEnd(
	UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
	bool erase_temporary_display
){
	// IuWFNg`FbN
	MGPickObjects objs(current_objects());
	objs.reset_objects(mgAll_FSurface);
	if(objs.size() != 1){
		// cancel
		return MGSelectState::OnCommandEnd(3);
	}

	// vZJn
	SetStatusMessage(IDS_PROMPT_COMPUTE);
	CWaitCursor sandglass;

	// face  surface 
	MGObject* original_obj=objs.front().top_object();
	MGFSurface* original = original_obj->fsurface();
	ASSERT(original);
	// GelReplace ZȂ̂ŃRs[IuWFNg
	// negate() 
	MGFSurface* f = original->clone_fsurface();
	f->negateFS();

	if(!replace_object(original_obj, f->object_pointer())){
		return MGSelectState::OnCommandEnd(3);
	}
	return MGSelectState::OnCommandEnd(1);
}
