/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfKnotRemove.h
 * @brief MGSurfKnotRemoveTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFKNOTREMOVE_H__953A6320_74F4_4854_8003_3466A19833C1__INCLUDED_)
#define AFX_SURFKNOTREMOVE_H__953A6320_74F4_4854_8003_3466A19833C1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
#include "Common/LocateState.h"

/// @class MGSurfKnotRemoveTool SurfKnotRemove.h SurfCmd/SurfKnotRemove.h
///
/// Removes knots from a surface.
class MGSurfKnotRemoveTool : public MGCommandStateOwner{
public:
	explicit MGSurfKnotRemoveTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);

private:
	void calc_param_line(MGGelPositions&, const MGSBRep*);
	bool calc_knot();
	bool remove_knot(MGPickObject& po);
	bool remove_knot(int id, bool bU);

	// member data
	MGPickObject m_surf; ///< ΏۂƂȂȖ
	std::unique_ptr<MGSBRep> m_surf_tmp; ///< r̋Ȗ
	MGPickObjects m_ucurve; ///< \p
	MGPickObjects m_vcurve; ///< \p

	friend class MGSurfKnotRemoveSSurf;
	friend class MGSurfKnotRemoveSKnot;
};

/// @class MGSurfKnotRemoveSSurf
///
/// mbg邽߂̑f̋ȖʂIB
/// ɂMGSBRep̂ݗLƂB
class MGSurfKnotRemoveSSurf:public MGSelectState{
public:
	MGSurfKnotRemoveSSurf(MGSurfKnotRemoveTool* owner);

	MGSurfKnotRemoveTool* state_owner(){
		return static_cast<MGSurfKnotRemoveTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);
};

/// @class MGSurfKnotRemoveSKnot
///
/// mbgp[^Cŕ\āAsbNB
class MGSurfKnotRemoveSKnot:public MGSelectState{
public:
	MGSurfKnotRemoveSKnot(MGSurfKnotRemoveTool* owner);

	MGSurfKnotRemoveTool* state_owner(){
		return static_cast<MGSurfKnotRemoveTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);
};

#endif // !defined(AFX_SURFKNOTREMOVE_H__953A6320_74F4_4854_8003_3466A19833C1__INCLUDED_)
