/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfGridPointsTool.h
 * @brief MGSurfGridPointsTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFGRIDPOINTSTOOL_H__464814CB_E2C2_402B_8C35_8B0DEE8AD418__INCLUDED_)
#define AFX_SURFGRIDPOINTSTOOL_H__464814CB_E2C2_402B_8C35_8B0DEE8AD418__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGSurfGridPointsTool SurfGridPointsTool.h SurfCmd/SurfGridPointsTool.h
///
/// Creates a surface by control points.
class MGSurfGridPointsTool : public MGLocateState{
public:
	explicit MGSurfGridPointsTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);
	virtual bool OnLocated(const MGLocateInfo& info);

private:
	bool input_param();

	int m_nu; ///< U ̐_̌
	int m_nv; ///< V ̐_̌
	int m_total; ///< == m_nu * m_nv
};

#endif // !defined(AFX_SURFGRIDPOINTSTOOL_H__464814CB_E2C2_402B_8C35_8B0DEE8AD418__INCLUDED_)
