/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfFromEdgesTool.h
 * @brief MGSurfFromEdgesTool NX̃C^[tFCX
 */
#if !defined(AFX_SurfFromEdgesTool_H__FF3B0C23_812E_4CCD_B5EA_D1DE1CAAD27F__INCLUDED_)
#define AFX_SurfFromEdgesTool_H__FF3B0C23_812E_4CCD_B5EA_D1DE1CAAD27F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGSurfFromEdgesTool SurfFromEdgesTool.h SurfCmd/SurfFromEdgesTool.h
///
/// Creates a surface from 2, 3, or 4 edge curves.
class MGSurfFromEdgesTool : public MGSelectState{
public:
	MGSurfFromEdgesTool(fugenDoc* pDoc, size_t nEdge);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
			//unselected_objects.size()>=1 only when the already selected objects are selected
			//when add mode is set(or when operation is done with a crtl key pressed).
		);

private:
	size_t m_nEdge; // R}hK肷J[ǔ
	size_t m_nCount; // ۂɃsbNꂽJ[ǔ
	UniqueCurve m_curve[4]; // Ȗʂ̕ӂƂȂȐ

	UINT m_nIDS; ///< error message
};

// t@Ng[p
MGCommandBase* CreateSurfFromEdgesTool(fugenDoc* pDoc, UINT nCmdID);

/// @class MGSurfFrom4Edges SurfFromEdgesTool.h SurfCmd/SurfFromEdgesTool.h
/// ڑlӖʂƓJ[uu4ӂwvR}h
class MGSurfFrom4Edges : public MGSelectState{
public:
	MGSurfFrom4Edges(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
			//unselected_objects.size()>=1 only when the already selected objects are selected
			//when add mode is set(or when operation is done with a crtl key pressed).
		);

private:
	bool calculate();
	void prompt_message() const;

	MGPickObject m_umin_c; ///< MGCurve
	MGPickObject m_umax_c; ///< MGCurve
	MGPickObject m_vmin_c; ///< MGCurve
	MGPickObject m_vmax_c; ///< MGCurve

	UINT m_nIDS; ///< error message
};

#endif // !defined(AFX_SurfFromEdgesTool_H__FF3B0C23_812E_4CCD_B5EA_D1DE1CAAD27F__INCLUDED_)
