/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfExtend.h
 * @brief MGSurfExtendTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFEXTEND_H__96053A8C_B84F_4FA8_889D_20CE0ECF2D98__INCLUDED_)
#define AFX_SURFEXTEND_H__96053A8C_B84F_4FA8_889D_20CE0ECF2D98__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"
#include "mg/PickObjectSB.h"
#include "GLExtendDlgBase.h"

class CGLSurfExtendDlg;

/** @class MGSurfExtendTool SurfExtend.h "SurfCmd.SurfExtend.h"
 *  Extends a surface.
 */
class MGSurfExtendTool : public MGSelectState
{
public:
	explicit MGSurfExtendTool(fugenDoc*);
	~MGSurfExtendTool()=default;

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);
	virtual bool OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	objs,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);

	/////////////////functions for draw_temporary()////////////
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

	void UpdateView();

	void Execute();

	CGLSurfExtendDlg* getSurfExtendDialog();

private:
	std::unique_ptr<MGSurface> calculate();

	MGPickObjectSB		m_sb;     //  MGSurface
	std::unique_ptr<MGSurface> m_spPreview; // ꎞ`p MGSurface
};

#endif // !defined(AFX_SURFEXTEND_H__96053A8C_B84F_4FA8_889D_20CE0ECF2D98__INCLUDED_)
