/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file SurfBlendAll.h
 * @brief MGSurfBlendAllTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFFUNCALL_H__65C8A7DC_C78B_4EFB_951A_D2681A116EE6__INCLUDED_)
#define AFX_SURFFUNCALL_H__65C8A7DC_C78B_4EFB_951A_D2681A116EE6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mg/SBRep.h"
#include "Common/SelectState.h"

/// @class MGSurfBlendAllTool SurfBlendAll.h SurfCmd/SurfBlendAll.h
///
/// Creates a surface by four edge curves.
/// The curves you select must meet at their ends (or cross). 
class MGSurfBlendAllTool : public MGSelectState{  
	friend class CGLBlendFuncDlg;

public:
	explicit MGSurfBlendAllTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
		//=1: display "xxxx" normally end.
		//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

	//Get the dialog pointer.
	CGLBlendFuncDlg* getBlendFuncDlg();

	/////////////////functions for draw_temporary()////////////
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	void blend_curve(double s, double e, MGLBRep& b);
	void build_surf();//Build m_surf from the current dialog data.
	void prompt_message() const;

	MGPickObject m_umin_c; ///< MGCurve
	MGPickObject m_umax_c; ///< MGCurve
	MGPickObject m_vmin_c; ///< MGCurve
	MGPickObject m_vmax_c; ///< MGCurve

	bool m_first; ///< _CAOĂȂǂ
	std::unique_ptr<MGLBRep> m_perimeter[4]; ///< ꎞ`pӋȐ
	MGSBRep m_surf; ///< ꎞ`pȖ
};

#endif // !defined(AFX_SURFFUNCALL_H__65C8A7DC_C78B_4EFB_951A_D2681A116EE6__INCLUDED_)
