/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file SurfBlendAcross.h
 * @brief MGSurfBlendAcrossTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFFUNCACROSS_H__B8167536_DFFF_486F_B46E_FEC3893062E0__INCLUDED_)
#define AFX_SURFFUNCACROSS_H__B8167536_DFFF_486F_B46E_FEC3893062E0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"
#include "mg/PickObjectSB.h"
#include "mg/SBRep.h"
#include "mg/SBRepTP.h"

/// @class MGSurfBlendAcrossTool SurfBlendAcross.h SurfCmd/SurfBlendAcross.h
///
/// Creates a surface between two surfaces by blending.
class MGSurfBlendAcrossTool : public MGSelectState{
	friend class CGLBlendDlg;

	bool m_first; ///< _CAO{bNXĂȂǂ
	std::pair<MGPickObjectSB, MGPickObjectSB> m_pair; ///< Ζʓm̈ʒu֌W(sbNꂽ)Ȗ

	// Ȗʂ̃R[i[ʒu
	bool m_continuousToNeiborEdge=false;
	bool m_Coons=true;
	MGVector m_s1, m_e1;//tangent vector of perimeter 1(start point and end).
	MGVector m_s3, m_e3;//tangent vector of perimeter 3(start point and end).
	double m_derivMagnitude[2];//Magnitude of the 1st derivative at perimeter 0 and 2.
	MGSBRepTP m_tp;//tangent plane at perimeter 0 and 2, perimeter 3, 1 are not specified.

	std::unique_ptr<MGLBRep> m_perimeter[4]; ///< ꎞ`p Ȗʂ̕
	std::unique_ptr<MGSBRep> m_surf; ///< ꎞ`p Ȗ

public:
	explicit MGSurfBlendAcrossTool(fugenDoc*);
	virtual ~MGSurfBlendAcrossTool()=default;

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags) override;
	//virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
		//=1: display "xxxx" normally end.
		//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

	///Output prompting message,
	void prompt_message()const override;

	/////////////////functions for draw_temporary()////////////
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

	CGLBlendDlg* getBlendDialog();

private:
	void make_perimeter();
	void perim_curve(
		const MGPosition& s, const MGPosition& e,
		const MGVector& ds, const MGVector& de,
		MGLBRep& b);
	void buildSurface();
};

#endif // !defined(AFX_SURFFUNCACROSS_H__B8167536_DFFF_486F_B46E_FEC3893062E0__INCLUDED_)
