/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file SplitTool.h
 * @brief NX MGSplitTool ̐錾
 */
#if !defined(AFX_SPLITLOCATEISOCURVES_INCLUDED_)
#define AFX_SPLITLOCATEISOCURVES_INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/LocateOnObjects.h"

/// @class MGSplitLocateIsocurves
///
/// ^[QbgT[tFXꖇ̎̓ʕXe[gB
/// @note dl [S6] ɑB
class MGSplitLocateIsocurves : public MGLocateOnObjects{
	MGPickObject m_target;
	int m_direction; ///< current parameter direction, 0:u=const, 1:v=const, 2=both.

	///(m_paramKind[i], m_param[i]) are one pair.
	std::vector<int> m_paramKinds; ///<indicates m_param[i]'s parameter direction,
		///0:u=const, 1:v=const, 2=both.
	std::vector<MGPosition> m_params; ///< T[tFXAC\J[uŕۂɗpBV B
	std::vector<UniqueCurve> m_preview_isocurves; ///< ByIsocurves ɂm蕪

public:
	MGSplitLocateIsocurves(MGCommandStateOwner* owner, MGPickObject& target);

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* window, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);
	virtual void prompt_message()const;

	//Update the model from m_paramKinds, m_params.
	//Return value is true: successfully updated, false not.
	bool updateModel();

private:
	const MGFSurface* GetSplitTargetSurf()const;
	void AddSplitParam(const MGPosition& uv, int direction);
	void AddPreviewCurves(const MGPosition& uv, bool isU);
	void RemoveSplitParam();
	void resetPreview();
	void DrawIsocurves(const MGColor& color, std::vector<UniqueCurve>& curves,mgSysGL& sgl,fugenView* pView);
};

#endif // !defined(AFX_SPLITLOCATEISOCURVES_INCLUDED_)
 