/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file RectCVTool.h
 * @brief MGRectCVTool NX̃C^[tFCX
 */
#if !defined(AFX_RECTCVTOOL_H__79A84D71_ECB6_4CF3_B89A_D6A8368AD169__INCLUDED_)
#define AFX_RECTCVTOOL_H__79A84D71_ECB6_4CF3_B89A_D6A8368AD169__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGRectCVToolBase RectCVTool.h "SurfCmd/RectCVTool.h"
///
/// S_{2 _ wn̎lp`R}hNX̊
class MGRectCVToolBase : public MGLocateState{
public:
	MGRectCVToolBase(fugenDoc* pDoc, int nCmdID);
	virtual bool OnLocated(const MGLocateInfo& info);

	/////////////////functions for draw_temporary()////////////
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

protected:
	void prompt_message() const;
	virtual void make_model() = 0;
	
private:
};

/// @class MGRectFaceCVTool RectCVTool.h "SurfCmd/RectCVTool.h"
///
/// Creates a rectangle plane with specified two corners.
class MGRectFaceCVTool : public MGRectCVToolBase{
public:
	explicit MGRectFaceCVTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual void make_model();
};

/// @class MGPlaneCenterTool RectCVTool.h "SurfCmd/RectCVTool.h"
///
/// Creates a plane with specified three points.
class MGPlaneCenterTool : public MGRectCVToolBase{
public:
	explicit MGPlaneCenterTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual void make_model();
};

#endif // !defined(AFX_RECTCVTOOL_H__79A84D71_ECB6_4CF3_B89A_D6A8368AD169__INCLUDED_)
