/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file Rect3PTool.h
 * @brief MGRect3PTool NX̃C^[tFCX
 */
#if !defined(AFX_RECT3PTOOL_H__5F80AE9C_3882_4BB8_8A29_0BE515F015FE__INCLUDED_)
#define AFX_RECT3PTOOL_H__5F80AE9C_3882_4BB8_8A29_0BE515F015FE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGRect3PToolBase Rect3PTool.h "SurfCmd/Rect3PTool.h"
/// lp` - 3_wñR}hNX̊
class MGRect3PToolBase : public MGLocateState{
public:
	MGRect3PToolBase(fugenDoc* pDoc, int nCmdID);
	virtual bool OnLocated(const MGLocateInfo& info);

	/////////////////functions for draw_temporary()////////////
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

protected:
	virtual void make_model() = 0;
	
private:
	void prompt_message() const;
};

/// class MGRectFace3PTool Rect3PTool.h "SurfCmd/Rect3PTool.h"
///
/// Creates a rectangle plane through three points, that is,
/// both endpoints of an edge and a point on the across edge
class MGRectFace3PTool : public MGRect3PToolBase{
public:
	explicit MGRectFace3PTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual void make_model();
};

/// class MGPlane3PTool Rect3PTool.h "SurfCmd/Rect3PTool.h"
///
/// Creates a plane with specified three points.
class MGPlane3PTool : public MGRect3PToolBase{
public:
	explicit MGPlane3PTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual void make_model();
};

#endif // !defined(AFX_RECT3PTOOL_H__5F80AE9C_3882_4BB8_8A29_0BE515F015FE__INCLUDED_)
