/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file Rect2VTool.h
 * @brief MGRect2VTool NX̃C^[tFCX
 */
#if !defined(AFX_RECT2VTOOL_H__ECC8E043_F759_4AAD_BEB6_634EC01B59C2__INCLUDED_)
#define AFX_RECT2VTOOL_H__ECC8E043_F759_4AAD_BEB6_634EC01B59C2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGRect2VToolBase Rect2VTool.h "SurfCmd/Rect2VTool.h"
/// 2_wn̎lp`R}hNX̊
class MGRect2VToolBase : public MGLocateState{
public:
	MGRect2VToolBase(fugenDoc* pDoc, int nCmdID);

	virtual bool initiate_tool();
	virtual bool OnLocated(const MGLocateInfo& info);

	/////////////////functions for draw_temporary()////////////
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);
	
protected:
	void prompt_message()const;
	virtual void make_model() = 0;

private:
};

/// @class MGRectFace2VTool Rect2VTool.h "SurfCmd/Rect2VTool.h"
///
/// Creates a rectangle plane with specified two corners.
class MGRectFace2VTool : public MGRect2VToolBase{
public:
	explicit MGRectFace2VTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual void make_model();
};

/// @class MGPlaneVertTool Rect2VTool.h "SurfCmd/Rect2VTool.h"
///
/// Creates a plane with specified two corners.
class MGPlaneVertexTool : public MGRect2VToolBase{
public:
	explicit MGPlaneVertexTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual void make_model();
};

#endif // !defined(AFX_RECT2VTOOL_H__ECC8E043_F759_4AAD_BEB6_634EC01B59C2__INCLUDED_)

