/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// PlaneEquation.cpp: MGPlaneEquationTool NX̃Cve[V

#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "SurfCmd/PlaneEquation.h"
#include "mg/Plane.h"
#include "GLPlaneEquationDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGPlaneEquationTool

MGPlaneEquationTool::MGPlaneEquationTool(fugenDoc* pDoc)
	 : MGCommandStateOwner(pDoc, ID_SURFACE_PLANE_EQUATION)
{
}

MGCommandBase* MGPlaneEquationTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGPlaneEquationTool(pDoc);
}

bool MGPlaneEquationTool::initiate_tool(){
	MGCommandStateOwner::initiate_tool();
	SetStatusMessage(IDS_PROMPT_PARAMETER);

	// _CAO{bNX\
	CGLPlaneEquationDlg dlg;
	if(IDOK != dlg.DoModal()){
		// cancel
		return OnCommandEnd(3);
	}
	double g[4] = {
		dlg.m_dA, dlg.m_dB, dlg.m_dC, dlg.m_dD
	};
	add_object_to_current_group(new MGPlane(g));
	// R}hI
	return OnCommandEnd(1);
}
