/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// SnapAttrDlg.cpp : Cve[V t@C

#include "stdafx.h"
#include "mgGL/SnapAttrib.h"
#include "fugen.h"
#include "Common/CursorRestriction.h"
#include "SnapAttrDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSnapAttrDlg _CAO


CSnapAttrDlg::CSnapAttrDlg(CWnd* pParent /*=NULL*/)
: CDialog(CSnapAttrDlg::IDD, pParent)
,m_dAngleSnapAngleMin(-mgInfiniteVal),m_dAngleSnapAngleMax(mgInfiniteVal){
	//{{AFX_DATA_INIT(CSnapAttrDlg)
	m_bEnd = FALSE;
	m_bKnot = FALSE;
	m_bNear = FALSE;
	m_bVertex = FALSE;
	m_bCenter = FALSE;
	m_bGrid = FALSE;
	m_dSnapX = 0.0;
	m_dSnapY = 0.0;
	//}}AFX_DATA_INIT
}


void CSnapAttrDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSnapAttrDlg)
	DDX_Check(pDX, IDC_CHECK_SNAP_END, m_bEnd);
	DDX_Check(pDX, IDC_CHECK_SNAP_KNOT, m_bKnot);
	DDX_Check(pDX, IDC_CHECK_SNAP_NEAR, m_bNear);
	DDX_Check(pDX, IDC_CHECK_SNAP_VERTEX, m_bVertex);
	DDX_Check(pDX, IDC_CHECK_SNAP_CENTER, m_bCenter);
	DDX_Check(pDX, IDC_CHECK_SNAP_GRID, m_bGrid);

	DDX_Text(pDX, IDC_EDIT_SNAP_X, m_dSnapX);
	DDV_MinMaxDouble(pDX, m_dSnapX, 0., 64.);
	DDX_Text(pDX, IDC_EDIT_SNAP_Y, m_dSnapY);
	DDV_MinMaxDouble(pDX, m_dSnapY, 0., 64.);

	DDX_Check(pDX, IDC_CHECK_ANGLE_SNAP, m_bAngleSnap);
	DDX_Text(pDX, IDC_EDIT_ANGLE_SNAP, m_dAngleSnapAngle);
	DDV_MinMaxDouble(pDX, m_dAngleSnapAngle, m_dAngleSnapAngleMin, m_dAngleSnapAngleMax);

	DDX_Check(pDX, IDC_CHECK_DISTANCE_SNAP, m_distaneRestriction);
	DDX_Text(pDX, IDC_EDIT_LENGTH_SNAP, m_distanceLimit);
	DDV_MinMaxDouble(pDX, m_distanceLimit, 0., mgInfiniteVal);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSnapAttrDlg, CDialog)
	//{{AFX_MSG_MAP(CSnapAttrDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSnapAttrDlg bZ[W nh

BOOL CSnapAttrDlg::OnInitDialog(){
	CDialog::OnInitDialog();

	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	MGCursorRestriction& crsrRestrctn=theCursorRestriction();
	if(crsrRestrctn.isAETUpdateProhibitted()){
		CWnd* pWnd1 = GetDlgItem(IDC_CHECK_ANGLE_SNAP);
		pWnd1->EnableWindow(FALSE);
		CWnd* pWnd2 = GetDlgItem(IDC_EDIT_ANGLE_SNAP);
		pWnd2->EnableWindow(FALSE);
	}	
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CSnapAttrDlg::ImportFromSnap(
	const MGSnapAttrib& snap
){
	m_bEnd    = snap.getEnd();
	m_bKnot   = snap.getKnot();
	m_bNear   = snap.getNear();
	m_bVertex = snap.getVertex();
	m_bCenter = snap.getCenter();
	m_bGrid   = snap.getGrid();
	const float* aperture=snap.getSnapAperture();
	m_dSnapX  = aperture[0];
	m_dSnapY  = aperture[1];

	MGCursorRestriction& crsrRestrctn=theCursorRestriction();
	m_dAngleSnapAngle=crsrRestrctn.get_angle();
	m_bAngleSnap=crsrRestrctn.isAngleMode();

	std::pair<bool, double>& distR=crsrRestrctn.get_distanceAttrib();
	m_distaneRestriction=distR.first;
	m_distanceLimit=distR.second;
}

void CSnapAttrDlg::ExportToSnap(MGSnapAttrib& snap){
	snap.setEnd(m_bEnd == TRUE);
	snap.setKnot(m_bKnot == TRUE);
	snap.setNear(m_bNear == TRUE);
	snap.setVertex(m_bVertex == TRUE);
	snap.setCenter(m_bCenter == TRUE);
	snap.setGrid(m_bGrid == TRUE);
	float aper[2]={(float)m_dSnapX,(float)m_dSnapY};
	snap.setSnapAperture(aper);

	MGCursorRestriction& crsrRestrctn=theCursorRestriction();
	if(!crsrRestrctn.isAETUpdateProhibitted()){
		crsrRestrctn.set_angle(m_dAngleSnapAngle);
		if(m_bAngleSnap)
			crsrRestrctn.addAngleMode();
	}

	std::pair<bool, double>& distR=crsrRestrctn.get_distanceAttrib();
	distR.first=m_distaneRestriction==TRUE;
	distR.second=m_distanceLimit;
}
