/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file PickDlg.cpp
 * @brief PickDlg.h ̎
 */
#include "stdafx.h"
#include "PickDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPickDlg _CAO

CPickDlg::CPickDlg(fugenView* pView, const MGPickObjects& tmp) : 
	CDialog(CPickDlg::IDD),
	m_candidate(tmp),
	m_pView(pView){
	//{{AFX_DATA_INIT(CPickDlg)
	//}}AFX_DATA_INIT
	
	ASSERT(m_candidate.size() > 1);
	ASSERT_VALID(m_pView);
}

void CPickDlg::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPickDlg)
	DDX_Control(pDX, IDC_POBJ_LIST, m_lsbox);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPickDlg, CDialog)
	//{{AFX_MSG_MAP(CPickDlg)
	ON_LBN_DBLCLK(IDC_POBJ_LIST, OnDblclkPobjList)
	ON_LBN_SELCHANGE(IDC_POBJ_LIST, OnSelchangePobjList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPickDlg bZ[W nh
#define MAX_PICKNUM 8 //mzximu number to display  names in the pick dialogue.
BOOL CPickDlg::OnInitDialog()
{
	if(!CDialog::OnInitDialog())
		return FALSE;
	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	// 1 - Save the current objects.
	m_saved = GetDocument()->current_objects();

	// 2 - List the candidate objects
	MGPickObjects::iterator i = m_candidate.begin();
	int nItems = 0;
	for(; i!=m_candidate.end() && nItems<MAX_PICKNUM; ++i,++nItems){
		const MGObject* obj = (**i).top_object();
		CString strKind = CA2T(obj->whoami().c_str());
		if(strKind.IsEmpty()){
			strKind.LoadString(IDS_UNKNOWN_TYPE);
		}
		m_lsbox.AddString(strKind);
	}
	m_lsbox.SetCurSel(0);

	
	//Items area
	CRect rctItems; m_lsbox.GetItemRect(0, rctItems);
	int heightItems = rctItems.Height()*nItems+4;
	rctItems.bottom = heightItems;
	m_lsbox.MoveWindow(rctItems);

	//OK button area
	CRect rctWhole; GetWindowRect(rctWhole);
	int widthWhole = rctWhole.Width();
	CWnd* pWndOK = GetDlgItem(IDOK);
	CRect rctWndOK; pWndOK->GetClientRect(rctWndOK);
	rctWndOK.OffsetRect(0, heightItems);
	int offset = (widthWhole - rctWndOK.Width())/2;
	rctWndOK.OffsetRect(offset, 4);
	pWndOK->MoveWindow(rctWndOK);

	CPoint point;::GetCursorPos(&point);
	point.Offset(20, 20);

	int heightWhole = 38 + heightItems + 4 + rctWndOK.Height() + 6;
	MoveWindow(point.x, point.y, widthWhole, heightWhole);
	fugenDoc* doc=GetDocument();
	doc->set_current_object(m_candidate[0]);
	return TRUE;
}

void CPickDlg::OnCancel(){
	GetDocument()->set_current_object(m_saved);
	m_pView->EndPick();
	CDialog::OnCancel();
}

void CPickDlg::OnOK(){
	size_t nItem = m_lsbox.GetCurSel();
	ASSERT(nItem != LB_ERR);
	ASSERT(nItem <= (size_t)m_candidate.size());

	m_result = m_candidate[(int)nItem];

	//Restore the pickd objects as the ones before this operation.
	//The current objects must be set by the commands.
	//CPickDlg does not change the currency.
	GetDocument()->set_current_object(m_saved);
	m_pView->EndPick();
	CDialog::OnOK();
}

void CPickDlg::OnDblclkPobjList(){
	OnOK();
}

void CPickDlg::OnSelchangePobjList(){
	size_t nItem = m_lsbox.GetCurSel();
	ASSERT(nItem != LB_ERR);
	ASSERT(nItem <= (size_t)m_candidate.size());
	GetDocument()->set_current_object(m_candidate[(int)nItem]);
}
