/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// ParamLineDlg.cpp : Cve[V t@C

#include "stdafx.h"
#include "ParamLineDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLParamLineDlg _CAO


CGLParamLineDlg::CGLParamLineDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGLParamLineDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGLParamLineDlg)
	m_strRangeU = _T("");
	m_strRangeV = _T("");
	m_nRadio = 0;
	m_dParam = 0.0;
	m_bNorm = FALSE;
	//}}AFX_DATA_INIT
}


void CGLParamLineDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGLParamLineDlg)
	DDX_Text(pDX, IDC_FROM_UV_STATIC_U, m_strRangeU);
	DDX_Text(pDX, IDC_FROM_UV_STATIC_V, m_strRangeV);
	DDX_Radio(pDX, IDC_RADIO_U, m_nRadio);
	DDX_Text(pDX, IDC_FROM_UV_EDIT, m_dParam);
	DDX_Check(pDX, IDC_CHECK_NORMALIZE, m_bNorm);
	//}}AFX_DATA_MAP

	if(m_bNorm){
		DDV_MinMaxDouble(pDX, m_dParam, 0, 1);
	}
	else if(m_nRadio == 0){
		// U ̋Ȑ
		DDV_MinMaxDouble(pDX, m_dParam, m_dLowerU, m_dUpperU);
	}
	else{
		// V ̋Ȑ
		DDV_MinMaxDouble(pDX, m_dParam, m_dLowerV, m_dUpperV);
	}
}

void CGLParamLineDlg::SetCaption(double lower, double upper, bool bSetU){
	CString& str = (bSetU ? m_strRangeU : m_strRangeV);
	str.Format(IDS_FORMAT_FROM_UV, lower, upper);
}

void CGLParamLineDlg::SetLimit(double dLowerU, double dUpperU, double dLowerV, double dUpperV){
	m_dLowerU = dLowerU;
	m_dUpperU = dUpperU;
	m_dLowerV = dLowerV;
	m_dUpperV = dUpperV;
}

BEGIN_MESSAGE_MAP(CGLParamLineDlg, CDialog)
	//{{AFX_MSG_MAP(CGLParamLineDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
