/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// BitmapHandle.cpp: CBitmapHandle NX̃Cve[V

#include "stdafx.h"
#include "BitmapHandle.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CBitmapHandle::~CBitmapHandle(){
	if(m_hBitmap){
		DeleteObject();
	}
}

HBITMAP CBitmapHandle::CreateCompatibleBitmap(HDC hDC, int nWidth, int nHeight)
{
	ASSERT(m_hBitmap == NULL);
	m_hBitmap = ::CreateCompatibleBitmap(hDC, nWidth, nHeight);
	return m_hBitmap;
}

BOOL CBitmapHandle::DeleteObject()
{
	ASSERT(m_hBitmap != NULL);
	BOOL bRet = ::DeleteObject(m_hBitmap);
	if(bRet)
		m_hBitmap = NULL;
	return bRet;
}

int CBitmapHandle::GetBitmap(BITMAP* pBitMap) const{
	ASSERT(m_hBitmap != NULL);
	return ::GetObject(m_hBitmap, sizeof(BITMAP), pBitMap);
}

bool CBitmapHandle::GetSize(SIZE& size) const
{
	ASSERT(m_hBitmap != NULL);
	BITMAP bm;
	if(!GetBitmap(&bm))
		return false;
	size.cx = bm.bmWidth;
	size.cy = bm.bmHeight;
	return true;
}
