/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// MeshTool.h: MGMeshTool NX̃C^[tFCX

#if !defined(AFX_FACETRANCEMESHTOOL_H__D601DFB7_EC58_46CD_806C_C5ACBB97B3CF__INCLUDED_)
#define AFX_FACETRANCEMESHTOOL_H__D601DFB7_EC58_46CD_806C_C5ACBB97B3CF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mg/MGStl.h"
#include "Common/SelectState.h"

class CGLMeshFromObjDlg;

// class MGMeshTool
//
// Surfaces, faces, and shells are shaded. 
class MGMeshTool : public MGSelectState
{
	MGPickObjects m_target; // target objects of 2 manifold.
	CGLMeshFromObjDlg* m_pDlg; // p[^w_CAO
	std::vector<UniqueStl> m_vecStl; // ʂbVMGStl̔z
	bool m_bDirty; // vr[Ƃ̃tO

public:
	explicit MGMeshTool(fugenDoc* pDoc);
	virtual ~MGMeshTool();

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel);

	// Compiles OpenGL's display list of temporary objects for each
	//standard views.
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

	// FROM VIEW MESSAGE
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);
	virtual bool OnCommandCanceled(UINT nIDS);

	//OnSelected will be invoked when an object is input.
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);

	// m_vecStl擾
	std::vector<UniqueStl>& GetVecStl(){return m_vecStl;}
	const std::vector<UniqueStl>& GetVecStl() const{ return m_vecStl; }

	// UI ŃR}hIƂɁAɌĂяoB
	void DetachDialog();

	// UI ŃbVZ[u̕KvꍇĂ
	void OnMeshSave();

	// vr[f[^̍č\zKvȂƂɌĂ
	void SetModifiedFlag(bool bDirty);

	// ݂̏ԂɊÂAeZ[VA_CAOAr[XVB
	void UpdateUI();

private:
	//Make stl data in m_vecStl from m_target.
	void make_stl();

	void ShowParamDlg();

	bool kill_dialog();
};

#endif // !defined(AFX_FACETRANCEMESHTOOL_H__D601DFB7_EC58_46CD_806C_C5ACBB97B3CF__INCLUDED_)
