/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// MainFrm.cpp : fugenMainFrame NX̓̒`s܂B

#include "stdafx.h"
#include "fugen.h"
#include <afxpriv.h>
#include "MainFrm.h"
#include "fugenView2D.h"
#include "GLWndMsg.h"
#include "GLPropPanel.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// fugenMainFrame

IMPLEMENT_DYNAMIC(fugenMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(fugenMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(fugenMainFrame)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_DRAWITEM()
	ON_WM_INITMENUPOPUP()
	ON_WM_MEASUREITEM()
	ON_WM_MENUSELECT()
	//}}AFX_MSG_MAP
	// O[o wv R}h
	ON_COMMAND(ID_HELP_FINDER, CMDIFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWnd::OnHelpFinder)

	// Toolsj[R}h
	ON_COMMAND(ID_PARAM_TESSELLATION, OnParamTessel)
	ON_UPDATE_COMMAND_UI(ID_PARAM_TESSELLATION, OnUpdateParamTessel)
	ON_COMMAND(ID_PARAM_TOLERANCE, OnParamTolerance)
	ON_UPDATE_COMMAND_UI(ID_PARAM_TOLERANCE, OnUpdateParamTolerance)
	ON_COMMAND(ID_TOOL_OPTION, OnToolOption)
	ON_UPDATE_COMMAND_UI(ID_TOOL_OPTION, OnUpdateToolOption)
	
	ON_MESSAGE(WM_GL_STATUSBAR, OnStatusMsg)

	// Window commands.
	ON_COMMAND_EX(ID_WINDOW_ARRANGE, OnMDIWindowCmd)
	ON_COMMAND_EX(ID_WINDOW_CASCADE, OnMDIWindowCmd)
	ON_COMMAND_EX(ID_WINDOW_TILE_HORZ, OnMDIWindowCmd)
	ON_COMMAND_EX(ID_WINDOW_TILE_VERT, OnMDIWindowCmd)
	ON_COMMAND_EX(ID_WINDOW_CLOSE_ALL, OnMDIWindowCmd)
	ON_COMMAND_EX(ID_WINDOW_CLOSE_INACTIVES, OnMDIWindowCmd)

	ON_COMMAND_EX(ID_VIEW_GLTOOL, OnBarCheck)
	ON_UPDATE_COMMAND_UI(ID_VIEW_GLTOOL, OnUpdateControlBarMenu)

	ON_COMMAND_EX(ID_VIEW_TOOLWND, OnBarCheck)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TOOLWND, OnUpdateControlBarMenu)

	ON_COMMAND_EX(ID_VIEW_COORD_BAR, OnBarCheck)
	ON_UPDATE_COMMAND_UI(ID_VIEW_COORD_BAR, OnUpdateControlBarMenu)

	ON_COMMAND_EX(ID_VIEW_RESTR_BAR, OnBarCheck)
	ON_UPDATE_COMMAND_UI(ID_VIEW_RESTR_BAR, OnUpdateControlBarMenu)

	ON_COMMAND_EX(ID_VIEW_PROMPT_BAR, OnBarCheck)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PROMPT_BAR, OnUpdateControlBarMenu)

	ON_NOTIFY(TBN_DROPDOWN, AFX_IDW_TOOLBAR, OnToolbarDropDown)
	ON_NOTIFY(TBN_DROPDOWN, ID_VIEW_GLTOOL, OnToolbarDropDown)

	ON_UPDATE_COMMAND_UI_RANGE(IDC_COORD_X, IDC_COORD_Z, OnUpdateCoordInput)
	ON_UPDATE_COMMAND_UI_RANGE(IDC_CONSTRAINT_DISTANCE, IDC_CONSTRAINT_ANGLE_OK, OnUpdateCoordInput)

	ON_MESSAGE(WM_FUGEN_OUTPUT, OnOutput)

	// ʃTCỸ`h~̂
END_MESSAGE_MAP()

//Status bar design.
static UINT indicators[] =
{
	ID_INDICATOR_COMMAND_MSG, //ÑR}h
	ID_INDICATOR_COORD, //coordinate value display message area.
	IDS_INDICATOR_GRID,
	IDS_INDICATOR_ANGLE,
	IDS_INDICATOR_PLANAR,
	ID_SEPARATOR // Xe[^X C CWP[^
};

/////////////////////////////////////////////////////////////////////////////
// fugenMainFrame NX̍\z/

fugenMainFrame::fugenMainFrame(){
}

fugenMainFrame::~fugenMainFrame(){
}

void fugenMainFrame::DockControlBarLeftOf(CControlBar* Bar, CControlBar* LeftOf){
	// Get MFC to adjust the dimensions of all docked ToolBars
	// so that GetWindowRect will be accurate.
	RecalcLayout(TRUE);
	
	CRect rect;
	LeftOf->GetWindowRect(&rect);
	rect.OffsetRect(1,0);

	DWORD dwStyle = LeftOf->GetBarStyle();
	UINT n = 0;
	n = (dwStyle & CBRS_ALIGN_TOP)             ? AFX_IDW_DOCKBAR_TOP    : n;
	n = (dwStyle & CBRS_ALIGN_BOTTOM && n==0)  ? AFX_IDW_DOCKBAR_BOTTOM : n;
	n = (dwStyle & CBRS_ALIGN_LEFT	  && n==0) ? AFX_IDW_DOCKBAR_LEFT   : n;
	n = (dwStyle & CBRS_ALIGN_RIGHT  && n==0)  ? AFX_IDW_DOCKBAR_RIGHT  : n;
	
	// When we take the default parameters on rect, DockControlBar will dock
	// each Toolbar on a seperate line. By calculating a rectangle, we in effect
	// are simulating a Toolbar being dragged to that location and docked.
	DockControlBar(Bar, n, &rect);
}

namespace{
	void SetDropdownButton(CToolBar& bar, UINT nID){
		int index = bar.CommandToIndex(nID);
		bar.SetButtonStyle(index, bar.GetButtonStyle(index) | TBSTYLE_DROPDOWN);
	}
}

// hbLOo[̃WXgZNV
LPCTSTR lpszSectBarState = _T("ControlBar\\State");

int fugenMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct){
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndStandardBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) 
		|| !m_wndStandardBar.LoadToolBar(IDR_MAINFRAME)
		)
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // 쐬Ɏs
	}

	m_wndStandardBar.GetToolBarCtrl().SetExtendedStyle(TBSTYLE_EX_DRAWDDARROWS);
	SetDropdownButton(m_wndStandardBar, ID_FILE_OPEN);

	if (!m_wndGLBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC,
		CRect(0, 0, 0, 0), ID_VIEW_GLTOOL) ||
		!m_wndGLBar.LoadToolBar(IDR_GLTOOL))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // 쐬Ɏs
	}

	m_wndGLBar.GetToolBarCtrl().SetExtendedStyle(TBSTYLE_EX_DRAWDDARROWS);
	SetDropdownButton(m_wndGLBar, ID_VIEW_ZOOM_WINDOW);
	SetDropdownButton(m_wndGLBar, ID_SNAP_DIALOG);

	if (!m_wndWndBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC,
		CRect(0, 0, 0, 0), ID_VIEW_TOOLWND) ||
		!m_wndWndBar.LoadToolBar(IDR_TOOL_WND))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // 쐬Ɏs
	}

	if (!m_fugenStatusBar.Create(this) ||
		!m_fugenStatusBar.SetIndicators(
		indicators, sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // 쐬Ɏs
	}
	InitStatusBar();

	CString title;
	VERIFY(title.LoadString(IDS_TOOLBAR_OUTPUT));
	if(!m_wndPrmptBar.Create(
		this, &m_dlgPrmpt, title,
		IDD_GLOUTPUTDLG, WS_CHILD | WS_VISIBLE | CBRS_BOTTOM, ID_VIEW_PROMPT_BAR))
	{
		TRACE0("Failed to create dialog bar\n");
		return -1;
	}

	// Toolbar docking start.

	EnableDocking(CBRS_ALIGN_ANY);

	VERIFY(title.LoadString(IDS_TOOLBAR_STANDARD));
	m_wndStandardBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndStandardBar.SetWindowText(title);
	DockControlBar(&m_wndStandardBar);

	VERIFY(title.LoadString(IDS_TOOLBAR_GL));
	m_wndGLBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndGLBar.SetWindowText(title);
	DockControlBarLeftOf(&m_wndGLBar, &m_wndStandardBar);

	VERIFY(title.LoadString(IDS_TOOLBAR_WINDOW));
	m_wndWndBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndWndBar.SetWindowText(title);
	DockControlBarLeftOf(&m_wndWndBar, &m_wndGLBar);

	m_wndPrmptBar.SetBarStyle(
		m_wndPrmptBar.GetBarStyle() | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndPrmptBar.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndPrmptBar, AFX_IDW_DOCKBAR_BOTTOM);

	LoadBarState(lpszSectBarState);
	//LoadWindowPos(); // App::InitInstance  ShowWindow OĂяo^C~OƂăxXg

	return 0;
}

// Load the dock state, but check the toolbar exists (MFC bug).
void fugenMainFrame::LoadBarState(LPCTSTR lpszProfileName){
	CDockState state;
	state.LoadState(lpszProfileName);
	for (int i = 0; i < state.m_arrBarInfo.GetSize(); i++){
		CControlBarInfo* pInfo = (CControlBarInfo*)state.m_arrBarInfo[i];
		ASSERT(pInfo != NULL);
		if (!pInfo->m_bFloating){
			pInfo->m_pBar = GetControlBar(pInfo->m_nBarID);
			if(pInfo->m_pBar == 0){
				delete pInfo;
				state.m_arrBarInfo.RemoveAt(i);
				i--;
			}
		}
	}
	SetDockState(state);
}

namespace{
	// WXg̃GgZNV
	LPCTSTR lpszSectWndPlcmnt = _T("Window\\Placement");
	// ̔z̃Gg
	LPCTSTR lpszEntryFlags = _T("Flags");
	LPCTSTR lpszEntryShow  = _T("Show");
	LPCTSTR lpszEntryMinX  = _T("PosMinX");
	LPCTSTR lpszEntryMinY  = _T("PosMinY");
	LPCTSTR lpszEntryMaxX  = _T("PosMaxX");
	LPCTSTR lpszEntryMaxY  = _T("PosMaxY");
	LPCTSTR lpszEntryRectL = _T("RectLeft");
	LPCTSTR lpszEntryRectT = _T("RectTop");
	LPCTSTR lpszEntryRectR = _T("RectRight");
	LPCTSTR lpszEntryRectB = _T("RectBottom");
}

BOOL fugenMainFrame::LoadWindowPos(){
	WINDOWPLACEMENT wp;
	memset(&wp, 0, sizeof wp);
	wp.length = sizeof wp;
	VERIFY(GetWindowPlacement(&wp));

	wp.flags = theApp.GetProfileInt(lpszSectWndPlcmnt, lpszEntryFlags, 0);
	wp.showCmd = theApp.GetProfileInt(lpszSectWndPlcmnt, lpszEntryShow, wp.showCmd);
	wp.ptMinPosition.x = (LONG)theApp.GetProfileInt(lpszSectWndPlcmnt, lpszEntryMinX, wp.ptMinPosition.x);
	wp.ptMinPosition.y = (LONG)theApp.GetProfileInt(lpszSectWndPlcmnt, lpszEntryMinY, wp.ptMinPosition.y);
	wp.ptMaxPosition.x = (LONG)theApp.GetProfileInt(lpszSectWndPlcmnt, lpszEntryMaxX, wp.ptMaxPosition.x);
	wp.ptMaxPosition.y = (LONG)theApp.GetProfileInt(lpszSectWndPlcmnt, lpszEntryMaxY, wp.ptMaxPosition.y);

	wp.rcNormalPosition.left = (LONG)theApp.GetProfileInt(lpszSectWndPlcmnt, lpszEntryRectL, 
		wp.rcNormalPosition.left);
	wp.rcNormalPosition.top = (LONG)theApp.GetProfileInt(lpszSectWndPlcmnt, lpszEntryRectT, 
		wp.rcNormalPosition.top);
	wp.rcNormalPosition.right = (LONG)theApp.GetProfileInt(lpszSectWndPlcmnt, lpszEntryRectR, 
		wp.rcNormalPosition.right);
	wp.rcNormalPosition.bottom = (LONG)theApp.GetProfileInt(lpszSectWndPlcmnt, lpszEntryRectB, 
		wp.rcNormalPosition.bottom);

	AfxGetApp()->m_nCmdShow = wp.showCmd;
	wp.showCmd = 0;
	SetWindowPlacement(&wp);

	return TRUE;
}

void fugenMainFrame::SaveWindowPos() const{
	WINDOWPLACEMENT wp;
	memset(&wp, 0, sizeof wp);
	wp.length = sizeof wp;
	if(GetWindowPlacement(&wp)){
		if(IsZoomed()){
			wp.flags |= WPF_RESTORETOMAXIMIZED;
		}
		theApp.WriteProfileInt(lpszSectWndPlcmnt, lpszEntryFlags, wp.flags);
		theApp.WriteProfileInt(lpszSectWndPlcmnt, lpszEntryShow, wp.showCmd);
		theApp.WriteProfileInt(lpszSectWndPlcmnt, lpszEntryMinX, wp.ptMinPosition.x);
		theApp.WriteProfileInt(lpszSectWndPlcmnt, lpszEntryMinY, wp.ptMinPosition.y);
		theApp.WriteProfileInt(lpszSectWndPlcmnt, lpszEntryMaxX, wp.ptMaxPosition.x);
		theApp.WriteProfileInt(lpszSectWndPlcmnt, lpszEntryMaxY, wp.ptMaxPosition.y);

		theApp.WriteProfileInt(lpszSectWndPlcmnt, lpszEntryRectL, wp.rcNormalPosition.left);
		theApp.WriteProfileInt(lpszSectWndPlcmnt, lpszEntryRectT, wp.rcNormalPosition.top);
		theApp.WriteProfileInt(lpszSectWndPlcmnt, lpszEntryRectR, wp.rcNormalPosition.right);
		theApp.WriteProfileInt(lpszSectWndPlcmnt, lpszEntryRectB, wp.rcNormalPosition.bottom);
	}
}

//Initialize the status bar after Create() and SetIndicators().
//The design of the Status bar is as:
// (*COMMAND_MSG,*COORD,*GRID,*ANGLE,ID_SEPARATOR).
//width=(700,200,40,150,remainder)
void fugenMainFrame::InitStatusBar(){
	CStatusBarCtrl& ctrl = m_fugenStatusBar.GetStatusBarCtrl();

	// Initialize tooltips
	m_fugenStatusBar.SetupToolTips();

	// Command name pane
	m_fugenStatusBar.SetPaneInfo(
		m_fugenStatusBar.CommandToIndex(ID_INDICATOR_COMMAND_MSG),ID_INDICATOR_COMMAND_MSG,
		SBPS_NORMAL,700);

	// Coordinate pane
	m_fugenStatusBar.SetPaneInfo(
		m_fugenStatusBar.CommandToIndex(ID_INDICATOR_COORD), ID_INDICATOR_COORD,
		SBPS_NORMAL, 205); // 200px ΍WOƂ\ł

	// Grid pane
	m_fugenStatusBar.SetPaneInfo(
		m_fugenStatusBar.CommandToIndex(IDS_INDICATOR_GRID), IDS_INDICATOR_GRID,
		SBPS_NORMAL, 40); // For the letters "GRID"

	// Angle pane
	m_fugenStatusBar.SetPaneInfo(
		m_fugenStatusBar.CommandToIndex(IDS_INDICATOR_ANGLE), IDS_INDICATOR_ANGLE,
		SBPS_NORMAL, 80); // For the letters "ANGLE:90.0", "ELEVATE", or "TAB"

		// Angle pane
	m_fugenStatusBar.SetPaneInfo(
		m_fugenStatusBar.CommandToIndex(IDS_INDICATOR_PLANAR), IDS_INDICATOR_PLANAR,
		SBPS_NORMAL, 55); // For the letters "PLANAR"

	// Message pane
	// ̋悾L\łȂ΂ȂȂ
	m_fugenStatusBar.SetPaneStyle(m_fugenStatusBar.CommandToIndex(ID_SEPARATOR), SBPS_STRETCH);

	ctrl.SetText(_T(""), m_fugenStatusBar.CommandToIndex(IDS_INDICATOR_GRID), SBT_OWNERDRAW);
	ctrl.SetText(_T(""), m_fugenStatusBar.CommandToIndex(IDS_INDICATOR_ANGLE), SBT_OWNERDRAW);
	ctrl.SetText(_T(""), m_fugenStatusBar.CommandToIndex(IDS_INDICATOR_PLANAR), SBT_OWNERDRAW);
}

BOOL fugenMainFrame::PreCreateWindow(CREATESTRUCT& cs){
	if( !CMDIFrameWnd::PreCreateWindow(cs) )
		return FALSE;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// fugenMainFrame NX̐ff

#ifdef _DEBUG
void fugenMainFrame::AssertValid() const{
	CMDIFrameWnd::AssertValid();
}

void fugenMainFrame::Dump(CDumpContext& dc) const{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// fugenMainFrame bZ[W nh

void fugenMainFrame::OnClose() {
	SaveBarState(lpszSectBarState);
	SaveWindowPos();
	CMDIFrameWnd::OnClose();
}

LRESULT fugenMainFrame::OnStatusMsg(WPARAM wParam, LPARAM lParam){
	if(m_fugenStatusBar.GetSafeHwnd()!=NULL){
		 return m_fugenStatusBar.SendMessage(WM_GL_STATUSBAR, wParam, lParam);
	}
	return 0L;
}
BOOL fugenMainFrame::OnMDIWindowCmd(UINT nID){
	BOOL bRet = TRUE;
	switch(nID){
	case ID_WINDOW_CLOSE_ALL:
		{
			CMDIChildWnd* pWnd = MDIGetActive();
			do{
				pWnd->SendMessage(WM_CLOSE, 0, 0);
				if(IsWindow(pWnd->m_hWnd))
					break;
				MDINext();
				pWnd = MDIGetActive();
			}while(pWnd);
		}
		break;
	case ID_WINDOW_CLOSE_INACTIVES:
		{
			CMDIChildWnd* pWndActive = MDIGetActive();
			CMDIChildWnd* pWnd, *pWndNext;
			do{
				pWnd = MDIGetActive();
				if(pWnd!=pWndActive)
					pWnd->SendMessage(WM_CLOSE, 0, 0);
				MDINext();
				pWndNext = MDIGetActive();
			}while(pWndNext != pWnd);
		}
		break;
	case ID_WINDOW_ARRANGE:
	default:
		// Send MFC's standard message to the parent window.
		bRet = CMDIFrameWnd::OnMDIWindowCmd(nID);
	};
	return bRet;
}

void fugenMainFrame::OnToolbarDropDown(NMHDR* pNMHDR, LRESULT* plRes){
	NMTOOLBAR* pnmtb = reinterpret_cast<NMTOOLBAR*>(pNMHDR);
	const int iItem = pnmtb->iItem;
	CMenu menu;
	CToolBar* pBar = 0;
	UINT nIDResource = 0;
	switch(iItem){
	case ID_FILE_OPEN:
		pBar = &m_wndStandardBar;
		nIDResource = IDR_MENU_MRU;
		break;
	case ID_VIEW_ZOOM_WINDOW:
		pBar = &m_wndGLBar;
		nIDResource = IDR_MENU_ZOOM;
		break;
	case ID_SNAP_DIALOG:
		pBar = &m_wndGLBar;
		nIDResource = IDR_MENU_SNAP;
		break;
	default:
		return;
	}
	ASSERT(nIDResource);
	BOOL bRet = menu.LoadMenu(nIDResource);
	ASSERT(bRet);
	if(!bRet){
		return;
	}

	CMenu& popup = *menu.GetSubMenu(0);

	CRect rc;
	pBar->GetItemRect(pBar->CommandToIndex(iItem), rc);
	pBar->ClientToScreen(rc);
	popup.TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_VERTICAL,
		rc.left, rc.bottom, this, rc);
	menu.DestroyMenu();
}

void fugenMainFrame::OnUpdateCoordInput(CCmdUI* pCmdUI){
	pCmdUI->Enable(FALSE);
}

void fugenMainFrame::PopupMenu(CPoint pt){
	CMenu menu;
	if(!menu.LoadMenu(MAKEINTRESOURCE(IDR_MAINFRAME))){
		TRACE("Error LoadMenu!\n");
		return;
	}

	CMenu* pSubMenu = menu.GetSubMenu(1);
	if(!pSubMenu){
		TRACE("Error GetSubMenu(1)!\n");
		return;
	}

	pSubMenu = pSubMenu->GetSubMenu(0);
	if(!pSubMenu){
		TRACE("Error GetSubMenu(0)!\n");
		return;
	}

	UINT nItem = pSubMenu->GetMenuItemCount();
	while(nItem--){
		UINT nID = pSubMenu->GetMenuItemID(nItem);
		CControlBar* pBar = GetControlBar(nID);
		if(!pBar) continue;

		pSubMenu->CheckMenuItem(
			nID, 
			MF_BYCOMMAND | ((pBar->GetStyle() & WS_VISIBLE) ? MF_CHECKED : MF_UNCHECKED));
	}
	pSubMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, this);
}

BOOL fugenMainFrame::PreTranslateMessage(MSG* pMsg){
	if(pMsg->message == WM_RBUTTONDOWN){
		CWnd* pWnd = CWnd::FromHandlePermanent(pMsg->hwnd);
		CControlBar* pBar = DYNAMIC_DOWNCAST(CControlBar, pWnd);

		if(pBar){
			CMenu menu;
			CPoint pt;

			pt.x = LOWORD(pMsg->lParam);
			pt.y = HIWORD(pMsg->lParam);
			pBar->ClientToScreen(&pt);

			PopupMenu(pt);
		}
	}
	return CMDIFrameWnd::PreTranslateMessage(pMsg);
}

LRESULT fugenMainFrame::OnOutput(WPARAM wParam, LPARAM lParam){
	return m_dlgPrmpt.SendMessage(WM_FUGEN_OUTPUT, wParam, lParam);
}

void fugenMainFrame::OnToolOption(){
	CGLPropDialog panel(0);
	if(IDOK != panel.DoModal()){
		return;
	}
}

void fugenMainFrame::OnUpdateToolOption(CCmdUI* pCmdUI){
	pCmdUI->Enable();
}


void fugenMainFrame::OnParamTessel(){
	CGLPropDialog panel(0, 0, IDD_PROP_MESH);
	if(IDOK != panel.DoModal()){
		return;
	}
}

void fugenMainFrame::OnUpdateParamTessel(CCmdUI* pCmdUI){
	pCmdUI->Enable();
}


void fugenMainFrame::OnParamTolerance(){
	CGLPropDialog panel(0, 0, IDD_PROP_UNIT);
	if(IDOK != panel.DoModal()){
		return;
	}
}

void fugenMainFrame::OnUpdateParamTolerance(CCmdUI* pCmdUI){
	pCmdUI->Enable();
}
