/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno             */
/* All rights reserved.                                             */
/********************************************************************/

#include "stdafx.h"
#include "IO/util.h"

// ֗֐
CString AddNumberToPath(
	const CString& strPathName,
	const CString& strFormat,
	size_t nNumber
){
	CString strWork(strPathName);
	// gq (e.g. .stl)
	CString strExt(::PathFindExtension(strPathName));

	// gqȊO̕o
	::PathRemoveExtension(strWork.GetBuffer(MAX_PATH));
	strWork.ReleaseBuffer();

	// t@CɃCfbNXt
	CString strVolIndex;
	strVolIndex.Format(strFormat, nNumber);
	strWork += strVolIndex;

	// gq𕜋A
	::PathAddExtension(strWork.GetBuffer(MAX_PATH), strExt);
	strWork.ReleaseBuffer();

	return strWork;
}

//Convert array of string numerical values to MGVector instance.
//That is; string "xxx,yyy,zzz", or "(xxx,yyy,zzz)" to MGVector data,
//where xxx, yyy, and zzz are digit charactors.
void StringVectorConvert(
	const CString& stringNumerical,
	MGVector& vec
){
	if(stringNumerical.IsEmpty())
		return;

	// double l̔z
	vec=MGVector(0.,0.,0.);
	CString str=stringNumerical;
	if(str[0]=='(')
		str.Delete(0, 1);

	const TCHAR cComma = ',';
	int idvalue=0, nComma = str.Find(cComma);
	while(nComma != -1 && idvalue<=2){
		// sꍇ͏0.0Ԃ
		vec(idvalue++)=_tcstod(str.Left(nComma),NULL);
		str.Delete(0, nComma+1);
		nComma = str.Find(cComma);
	}
	if(!str.IsEmpty() && idvalue<=2){
		// sꍇ͏0.0Ԃ
		double d = _tcstod(str,NULL);
		vec(idvalue++)=d;
		str.Empty();
	}
}
