/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file GLUnitPropPane.cpp
 * @brief GLUnitPropPane.h ̎
 */
#include "stdafx.h"
#include "fugen.h"
#include "fugenDoc.h"
#include "GLUnitPropPane.h"
#include "Misc/UserPreference.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLUnitPropPane _CAO
//
//CGLUnitPropPane::CGLUnitPropPane(CGLPropDialog* propPanel)
//:CGLPropPane(propPanel)
//,m_dAbs(0.01), m_dLine(0.01), m_dAngle(0.01), m_dRel(0.01),
//m_dMachZero(DBL_EPSILON), m_dKnotRatio(250){
//}

CGLUnitPropPane::CGLUnitPropPane(fugenDoc* pDoc)
:CGLPropPane(pDoc){
}

void CGLUnitPropPane::DoDataExchange(CDataExchange* pDX)
{
	CGLPropPane::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGLUnitPropPane)
	DDX_Text(pDX, IDC_EDIT_PROP_UNIT_TOL_ABS, m_dAbs);
	DDX_Text(pDX, IDC_LINE_ZERO, m_dLine);
	DDX_Text(pDX, IDC_EDIT_PROP_UNIT_TOL_REL, m_dRel);
	DDX_Text(pDX, IDC_EDIT_PROP_UNIT_TOL_ANGLE, m_dAngle);
	DDX_Text(pDX, IDC_MACHINE_ZERO, m_dMachZero);
	DDX_Text(pDX, IDC_MAX_KNOT_RATIO, m_dKnotRatio);
	//}}AFX_DATA_MAP

	DDV_PositiveDouble(pDX, m_dAbs);
	DDV_PositiveDouble(pDX, m_dLine);
	DDV_PositiveDouble(pDX, m_dRel);
	DDV_PositiveDouble(pDX, m_dAngle);
	DDV_PositiveDouble(pDX, m_dMachZero);
	DDV_PositiveDouble(pDX, m_dKnotRatio);
}

BEGIN_MESSAGE_MAP(CGLUnitPropPane, CGLPropPane)
	//{{AFX_MSG_MAP(CGLUnitPropPane)
	ON_BN_CLICKED(IDC_BUTTON_PROP_UNIT_DEFAULT, OnButtonPropUnitDefault)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CGLUnitPropPane::OnButtonPropUnitDefault(){
	UserPreference& pref = UserPreference::getInstance();
	//const fugenDoc* pDoc = m_parentPropPanel->GetDocument();

	if(m_pTargetDoc==NULL){
	
	m_dAbs = pref.GetDoubleValue(upv_Tolerance_WorldZero, UserPreference::DefaultValue);
	m_dLine = pref.GetDoubleValue(upv_Tolerance_LineZero, UserPreference::DefaultValue);
	m_dRel = pref.GetDoubleValue(upv_Tolerance_RelZero, UserPreference::DefaultValue);
	m_dAngle = MGCL::decimalAlign(MGCL::radian_to_degree(pref.GetDoubleValue(upv_Tolerance_AngleZero, UserPreference::DefaultValue)), 6);
	m_dMachZero = pref.GetDoubleValue(upv_Tolerance_MachineZero, UserPreference::DefaultValue);
	m_dKnotRatio = pref.GetDoubleValue(upv_Tolerance_MaxKnotRatio, UserPreference::DefaultValue);
	} else {
		ASSERT_VALID(m_pTargetDoc);
		m_dAbs = pref.GetDoubleValue(upv_Tolerance_WorldZero, UserPreference::CurrentValue);
	m_dLine = pref.GetDoubleValue(upv_Tolerance_LineZero, UserPreference::CurrentValue);
	m_dRel = pref.GetDoubleValue(upv_Tolerance_RelZero, UserPreference::CurrentValue);
	m_dAngle = MGCL::decimalAlign(MGCL::radian_to_degree(pref.GetDoubleValue(upv_Tolerance_AngleZero, UserPreference::CurrentValue)), 6);
	m_dMachZero = pref.GetDoubleValue(upv_Tolerance_MachineZero, UserPreference::CurrentValue);
	m_dKnotRatio = pref.GetDoubleValue(upv_Tolerance_MaxKnotRatio, UserPreference::CurrentValue);
	}
	


	UpdateData(FALSE);
	Invalidate();
}

void CGLUnitPropPane::LoadUserProf(){
		UserPreference& pref = UserPreference::getInstance();

		m_dLine = pref.GetDoubleValue(upv_Tolerance_LineZero);
		m_dMachZero = pref.GetDoubleValue(upv_Tolerance_MachineZero);
		m_dKnotRatio = pref.GetDoubleValue(upv_Tolerance_MaxKnotRatio);
		m_dAngle = MGCL::decimalAlign(MGCL::radian_to_degree(pref.GetDoubleValue(upv_Tolerance_AngleZero)),6);
		m_dRel = pref.GetDoubleValue(upv_Tolerance_RelZero);
		m_dAbs = pref.GetDoubleValue(upv_Tolerance_WorldZero);

		UpdateData(FALSE);
}

BOOL CGLUnitPropPane::UpdateUserProf(){
	if(UpdateData()){
		double angTolRad =  MGCL::degree_to_radian(m_dAngle);
		UserPreference& pref = UserPreference::getInstance();
		pref.SetDoubleValue(upv_Tolerance_WorldZero, m_dAbs);
		pref.SetDoubleValue(upv_Tolerance_RelZero, m_dRel);
		pref.SetDoubleValue(upv_Tolerance_MachineZero, m_dMachZero);
		pref.SetDoubleValue(upv_Tolerance_LineZero, m_dLine);
		pref.SetDoubleValue(upv_Tolerance_AngleZero, angTolRad);
		pref.SetDoubleValue(upv_Tolerance_MaxKnotRatio, m_dKnotRatio);
		return TRUE;
	}
	return FALSE;
}

void CGLUnitPropPane::ResetToDefaultUserProf(){
	UserPreference& pref = UserPreference::getInstance();
	
	m_dAbs = pref.GetDoubleValue(upv_Tolerance_WorldZero, UserPreference::DefaultValue);
	m_dLine = pref.GetDoubleValue(upv_Tolerance_LineZero, UserPreference::DefaultValue);
	m_dRel = pref.GetDoubleValue(upv_Tolerance_RelZero, UserPreference::DefaultValue);
	m_dAngle = MGCL::decimalAlign(MGCL::radian_to_degree(pref.GetDoubleValue(upv_Tolerance_AngleZero, UserPreference::DefaultValue)), 6);
	m_dMachZero = pref.GetDoubleValue(upv_Tolerance_MachineZero, UserPreference::DefaultValue);
	m_dKnotRatio = pref.GetDoubleValue(upv_Tolerance_MaxKnotRatio, UserPreference::DefaultValue);

	UpdateData(False);
}

void CGLUnitPropPane::LoadDocContext(){
	ASSERT_VALID(m_pTargetDoc);
		const MGContext* ct = m_pTargetDoc->context();
		ASSERT(ct);

		const double* tolarray = ct->tolerance();
		m_dAbs = tolarray[0];
		m_dLine = tolarray[3];
		m_dRel = tolarray[1];
		m_dAngle = MGCL::decimalAlign(MGCL::radian_to_degree(tolarray[4]), 6); // UI  degree \
		m_dMachZero = tolarray[2];
		m_dKnotRatio = tolarray[5];

		UpdateData(FALSE);
}

BOOL CGLUnitPropPane::UpdateDocContext(){
	ASSERT_VALID(m_pTargetDoc);

	MGContext* ct = m_pTargetDoc->context();
	ASSERT(ct);
	double angTolRad =  MGCL::degree_to_radian(m_dAngle);
	double* tolarray = ct->tolerance();

	tolarray[0] = m_dAbs;
	tolarray[1] = m_dRel;
	tolarray[2] = m_dMachZero;
	tolarray[3] = m_dLine;
	tolarray[4] = angTolRad; // UI  degree \
	tolarray[5] = m_dKnotRatio;

	// MGTolerance::set_xxx() AB
	ct->exec_tolerance();
	return TRUE;
}

void CGLUnitPropPane::ResetToDefaultDocContext(){
	ASSERT_VALID(m_pTargetDoc);

	UserPreference& pref = UserPreference::getInstance();

	m_dAbs = pref.GetDoubleValue(upv_Tolerance_WorldZero, UserPreference::CurrentValue);
	m_dLine = pref.GetDoubleValue(upv_Tolerance_LineZero, UserPreference::CurrentValue);
	m_dRel = pref.GetDoubleValue(upv_Tolerance_RelZero, UserPreference::CurrentValue);
	m_dAngle = MGCL::decimalAlign(MGCL::radian_to_degree(pref.GetDoubleValue(upv_Tolerance_AngleZero, UserPreference::CurrentValue)), 6);
	m_dMachZero = pref.GetDoubleValue(upv_Tolerance_MachineZero, UserPreference::CurrentValue);
	m_dKnotRatio = pref.GetDoubleValue(upv_Tolerance_MaxKnotRatio, UserPreference::CurrentValue);

	UpdateData(FALSE);

}

