/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// GLTessWView.cpp : Cve[V t@C

#include "stdafx.h"
#include "Tl2/TL2Face.h"
#include "Tl2/TL2Triangles.h"
#include "mgGL/VBO.h"
#include "fugen.h"
#include "topo/Shell.h"
#include "GLTessWView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLTessWView

IMPLEMENT_DYNCREATE(CGLTessWView, fugenView)

CGLTessWView::CGLTessWView():fugenView(),m_f(0){;}
CGLTessWView::~CGLTessWView(){;}


BEGIN_MESSAGE_MAP(CGLTessWView, fugenView)
	//{{AFX_MSG_MAP(CGLTessWView)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGLTessWView bZ[W nh

///Initialize model.
void CGLTessWView::initializeModel(){
	if(!m_f) return;
	const MGBox& bx=m_f->get_box();
	cplane().setGridDataByBox(bx,1,getUserPrefGridColor());
	initializeViewingEnvironmentByBox(bx);
	set_display_list(&m_vbo);//glv->set_display_list(name);	
}

//Make openGL display list in the input glview.
void CGLTessWView::makeDisplayList(){
	if(!m_f)
		return;

	fugenDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	MGDrawParam tlparam(*pDoc->context());
	mgTL2Face face(tlparam,*m_f);
	mgTL2Triangles tlds(MGCL::XYZ,m_f->get_surface_pointer());
	face.tessellate(tlds);	

	m_vbo.LineWidth(1.f);// glLineWidth(1.f);
	m_vbo.drawShade(tlds, MGCL::WIRE,GL_LINE);
	m_vbo.setDirty(false);
}

void CGLTessWView::OnInitialUpdate(){
	CWaitCursor wait;

	fugenDoc& doc=document();
	// Set Window's title.
	CString strTitle;
	strTitle.Format(IDS_FORMAT_VIEW_TITLE_TESSW,doc.GetTitle());
	GetParent()->SetWindowText(strTitle);

	MGPickObjects picked(current_objects());
	if(!(m_f=picked.get_object_to_tessellate()))
		return;

/////////Generate OpenGL display list.//////////////////////
	InitOpenGL();

	const MGContext* ct = document().context();
	importDrawAttribFromContext(*ct);

	setEyePositionUpVector(MGVector(0.,0.,1.),MGVector(0.,1.,0.));
	set_perspective(true);
	initializeModel();

	makeDisplayList();
	copyCplaneEnability(doc.get_main_view());
}

void CGLTessWView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint){
	ASSERT(pSender != this);
	fugenView::OnUpdate(pSender, lHint, pHint);
}
