/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#if !defined(AFX_GLPROPPANEL_H__913EC100_3AE1_4530_B099_5F83BD812BD1__INCLUDED_)
#define AFX_GLPROPPANEL_H__913EC100_3AE1_4530_B099_5F83BD812BD1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"
#include <map>

class fugenDoc;
class CGLPropDialog;
class fugenView;

/////////////////////////////////////////////////////////////////////////////
// DDV

void DDV_PositiveDouble(CDataExchange* pDX, double dValue);
void DDV_AngleInt(CDataExchange* pDX, int nAngle);

/////////////////////////////////////////////////////////////////////////////
// CGLPropPane _CAO

class CGLPropPane : public CDialog{
public:
	CGLPropPane(fugenDoc* pTargetDoc);

	virtual void OnOK();
	virtual void OnCancel();
	virtual void OnApply();
	virtual void OnReset();

	virtual BOOL OnInitDialog();

	virtual void LoadData();
	virtual BOOL ApplyData();
	virtual void ResetToDefault();

	virtual void LoadUserProf();
	virtual BOOL UpdateUserProf();
	virtual void ResetToDefaultUserProf();

	virtual void LoadDocContext();
	virtual BOOL UpdateDocContext();
	virtual void ResetToDefaultDocContext();

protected:
	virtual void PostNcDestroy();

	/// ֗֐
	void AdjustDroppedWidth(CComboBox& combo, bool bUseScrollBar);

	fugenDoc* m_pTargetDoc;
};

/////////////////////////////////////////////////////////////////////////////
// CGLPropPanel _CAO

class CGLPropDialog : public CDialog{
	std::map<LPARAM, CGLPropPane*> m_pane;

	CRect        m_rcTree;
	CPoint       m_ptOrg;
	CGLPropPane* m_pPrevPane;
	fugenDoc*     m_pDoc;
	
	LPARAM m_nInitPageItemData; ///< ŏɌy[WZbgꍇɎg

// RXgNV
public:
	/// RXgN^[
	/// @param[in] pDoc ݒύXhLgiłj
	/// @param[in] pParent eEBhEiʏw肵Ȃj
	/// @param[in] lParam ŏɌy[W̃_CAO IDD
	CGLPropDialog(
		fugenDoc* pDoc,
		CWnd* pParent = 0,
		LPARAM lParam = 0);

// _CAO f[^
	//{{AFX_DATA(CGLPropPanel)
	enum { IDD = IDD_PROP };
	CTreeCtrl	m_tree;
	//}}AFX_DATA

	fugenDoc* GetDocument(){ 
		return m_pDoc;
	}
	const fugenDoc* GetDocument() const{ 
		return m_pDoc;
	}
	void SetDocument(fugenDoc* pDoc){ m_pDoc = pDoc;}

	fugenView* GetActiveView() const;

	virtual void OnOK();
	virtual void OnCancel();

// I[o[Ch
	//{{AFX_VIRTUAL(CGLPropPanel)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

// Cve[V
protected:
	virtual CGLPropPane* CreatePane(UINT nIDResource);
	void InsertPage(LPCTSTR lpszItem, HTREEITEM hItem, LPARAM lParam = 0);

	//{{AFX_MSG(CGLPropPanel)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangedTreeProp(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelchangingTreeProp(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnApply();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	BOOL ApplyData();
	void MakeTree();
public:
	afx_msg void OnBnClickedButton1();
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_GLPROPPANEL_H__913EC100_3AE1_4530_B099_5F83BD812BD1__INCLUDED_)
