/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// GLPromptBar.cpp : Cve[V t@C

#include "stdafx.h"
#include "GLPromptBar.h"
#include "fugen.h"

#include <afxpriv.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLPromptBar

CGLPromptBar::CGLPromptBar()
{
}

void CGLPromptBar::ClearEdit(){
	CEdit* pEdit = GetEdit();
	pEdit->SetSel(0, -1, TRUE);
	pEdit->Clear();
	// pEdit->SetWindowText(_T("")); A
}

CEdit* CGLPromptBar::GetEdit(){
	// MFC L̔ȃLXg
	return (CEdit*)GetDlgItem(IDC_EDIT_PROMPT);
}

bool CGLPromptBar::ParseLine(){
	CEdit* pEdit = GetEdit();
	// Ō̍s̃CfbNX擾
	int nLineIndex = pEdit->GetLineCount()-1;
	// ̍s̕(byte)擾
	const int nByteMax = 1024;
	int nByte = pEdit->LineLength(nLineIndex);
	if(nByte < nByteMax){
		// obt@
		// NVbNȎ@Ƃ...
		TCHAR szBuffer[nByteMax];

		nByte = pEdit->GetLine(nLineIndex, &szBuffer[0], nByte);
		ASSERT(nByte < nByteMax);
		szBuffer[nByte] = '\0';

		TRACE("buffer content: %s\n", szBuffer);
	}
	else if(nByte == 0){
		// 󃊃^[L[
	}
	else{
		// ͕񂪒
	}
	// GfBbgRg[NA
	pEdit->SetSel(0, -1, TRUE);
	pEdit->Clear();
	return TRUE;
}

BOOL CGLPromptBar::PreTranslateMessage(MSG* pMsg){
	// EnterL[̃vX̃Lb`
	// PreTranslateMessage ̃I[o[ChȂ
	if(pMsg->message == WM_KEYDOWN && pMsg->wParam == VK_RETURN){
		ParseLine();
		return TRUE;
	}
	return CDialogBar::PreTranslateMessage(pMsg);
}

BEGIN_MESSAGE_MAP(CGLPromptBar, CDialogBar)
	//{{AFX_MSG_MAP(CGLPromptBar)
	ON_WM_WINDOWPOSCHANGED()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CGLPromptBar bZ[W nh

void CGLPromptBar::OnWindowPosChanged(WINDOWPOS FAR* lpwndpos){
	CDialogBar::OnWindowPosChanged(lpwndpos);
	
	CEdit* pEdit = GetEdit();
	// 1. _CAOo[̂̃TCY擾
	CRect rcBase;
	GetClientRect(rcBase);
	int nWidth = rcBase.Width();
	int nHeight = rcBase.Height();

	// 2. ~jobt@EBhẼTCY擾
	CRect rcMiniBuf;
	pEdit->GetClientRect(rcMiniBuf);
	int nHeightMini = rcMiniBuf.Height();
	if(nHeight < nHeightMini) return;

	const CRect rcMargin(2, 2, 2, 2);

	pEdit->SetWindowPos(
		0, 
		rcMargin.left, rcMargin.top,
		nWidth - (rcMargin.left + rcMargin.right), 24,
		SWP_NOZORDER
		);
}
