/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
// GLParamView.cpp : Cve[V t@C

#include "stdafx.h"
#include "mgGL/VBO.h"
#include "fugen.h"
#include "GLParamView.h"
#include "topo/Edge.h"
#include "topo/Loop.h"
#include "topo/Shell.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLParamView

IMPLEMENT_DYNCREATE(CGLParamView, fugenView2D)

CGLParamView::CGLParamView():fugenView2D(3,'u','v'){;}
CGLParamView::~CGLParamView(){;}


BEGIN_MESSAGE_MAP(CGLParamView, fugenView2D)
	//{{AFX_MSG_MAP(CGLParamView)
	ON_WM_KEYDOWN()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGLParamView bZ[W nh

///Initialize model.
void CGLParamView::initializeModel(){
	if(!m_ParamObj) return;
	const MGFace* f=dynamic_cast<const MGFace*>(m_ParamObj);
	if(f){
		const MGSurface* sf=f->surface();
		const MGPlane* pl=dynamic_cast<const MGPlane*>(sf);
		if(pl) m_param_box=f->box_param();
		else m_param_box=sf->param_range();
	}else{
		const MGSurface* sf= dynamic_cast<const MGSurface*>(m_ParamObj);
		if(sf) m_param_box=sf->param_range();
		else{
			m_param_box=m_ParamObj->box();
		}
	}
	cplane().setGridDataByBox(m_param_box,2,getUserPrefGridColor());
	initializeViewingEnvironmentByBox(m_param_box);
	set_display_list(&m_vbo);
}

//Make openGL display list in the input glview.
void CGLParamView::makeDisplayList(){
//Generate OpenGL display list.
	m_vbo.LineWidth(1.f);// glLineWidth(1.f);
	m_vbo.setLineStipple(2,0x5555);
	m_vbo.drawRectangle(m_param_box);//param_rectangle(m_param_box);
	m_vbo.setLineStipple(0);//Set as solid lline.
	m_vbo.drawObjInParameterSpace(*m_ParamObj);
	m_vbo.setDirty(false);
}

void CGLParamView::OnInitialUpdate(){
	fugenDoc& doc=document();
	// Set Window's title.
	CString title(doc.GetTitle());
	CString strSuffix;
	strSuffix.LoadString(IDS_PARAM_VIEW_TITLE_SUFFIX);
	title += strSuffix;

	GetParent()->SetWindowText(title);

	const MGPickObjects& cobjs=current_objects();
	size_t nobj=cobjs.size();
	if(!nobj)
		return;

	//Get 1st face element (MGFace, MGLoop, MGSurface, or, MGEdge).
	const MGObject* obj;
	for(size_t i=0; i<nobj; i++){
		obj = cobjs[i].top_object();

		auto f = dynamic_cast<const MGFace*>(obj);
		if(f)
			goto show;
		auto sh = dynamic_cast<const MGShell*>(obj);
		if(sh){
			f=sh->face(0);
			if(f){
				obj=f;
				goto show;
			}
		}
		const MGLoop* lp=dynamic_cast<const MGLoop*>(obj);
		if(lp){
			obj=lp->face();
			if(!obj) obj=lp;
			goto show;
		}
		const MGEdge* edg=dynamic_cast<const MGEdge*>(obj);
		if(edg){
			obj=edg->face();
			if(!obj) obj=edg->loop();
			if(!obj) obj=edg;
			goto show;
		}
		auto sf = dynamic_cast<const MGSurface*>(obj);
		if(sf)
			goto show;
	}
	return;//If not found, return.

show:
	m_ParamObj=obj;
	InitOpenGL();

	const MGContext* ct = document().context();
	importDrawAttribFromContext(*ct);

	setEyePositionUpVector(MGVector(0.,0.,1.),MGVector(0.,1.,0.));
	set_perspective(false);
	initializeModel();

//Generate OpenGL display list.
	makeDisplayList();
	cplane().set_disable();
}

void CGLParamView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint){
	ASSERT(pSender != this);
	fugenView2D::OnUpdate(pSender, lHint, pHint);
}

void CGLParamView::redrawOnlythis(){
	make_RC_current();
	setViewMode(MGCL::WIREVIEW);
	updateAxisPictures();
	drawScene();
	release_dc();
}
