/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file GLOutputDlg.cpp
 * @brief GLOutputDlg.h ̎t@C
 */
#include "stdafx.h"
#include "fugen.h"
#include "GLOutputDlg.h"
#include "GLWndMsg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CMenuEdit::CMenuEdit()
{
}

BEGIN_MESSAGE_MAP(CMenuEdit, CEdit)
	ON_WM_CONTEXTMENU()
END_MESSAGE_MAP()

void CMenuEdit::OnContextMenu(CWnd* pWnd, CPoint pt)
{
	SetFocus();

	// p\[Xŕ\B
	CMenu menu;
	VERIFY(menu.LoadMenu(IDR_OUTPUT_CONTEXT_MENU));

	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup);

	// Rs[j[𖳌
	int nStart = -1, nEnd = -1;
	GetSel(nStart, nEnd);
	if(nStart == nEnd){
		pPopup->EnableMenuItem(
			WM_COPY, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
	}

	// ׂăNA𖳌
	if(GetWindowTextLength() == 0){
		pPopup->EnableMenuItem(
			ID_OUTPUT_CLEAR_ALL, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
	}

	// |bvAbvB
	// R}h[eBÔ߁AɐeEBhEw肷B
	pPopup->TrackPopupMenu(
		TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, this);
}

BOOL CMenuEdit::OnCommand(WPARAM wParam, LPARAM lParam)
{
	switch(LOWORD(wParam)){
	case WM_COPY:
	case ID_EDIT_COPY:
		// Rs[͋B
		SendMessage(LOWORD(WM_COPY));
		return TRUE;
	case ID_OUTPUT_CLEAR_ALL:
		// gI[NAB
		SetReadOnly(FALSE);
		SetSel(0, -1);
		Clear();
		SetReadOnly();
		return TRUE;
	default:
		return CEdit::OnCommand(wParam, lParam);
	}
}

// CGLOutputDlg _CAO

CGLOutputDlg::CGLOutputDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGLOutputDlg::IDD, pParent)
{
}

CGLOutputDlg::~CGLOutputDlg()
{
}

void CGLOutputDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CGLOutputDlg, CDialog)
	ON_MESSAGE(WM_FUGEN_OUTPUT, OnOutput)
	ON_WM_CTLCOLOR()
	ON_WM_SIZE()
END_MESSAGE_MAP()

BOOL CGLOutputDlg::OnInitDialog()
{
	if(!CDialog::OnInitDialog()){
		return FALSE;
	}

	m_edit.SubclassDlgItem(IDC_EDIT_PROMPT, this);
	m_edit.SetLimitText(UINT_MAX);

	RecalcChild();

	return TRUE;
}

LRESULT CGLOutputDlg::OnOutput(WPARAM wParam, LPARAM lParam)
{
	if(!lParam){
		return 0;
	}

	CEdit* pEdit = static_cast<CEdit*>(GetDlgItem(IDC_EDIT_PROMPT));
	ASSERT(pEdit->GetSafeHwnd());

	// Lbg𖖔ɒǉ
	const int nLen = pEdit->GetWindowTextLength();
	pEdit->SetSel(nLen, nLen, FALSE);

	// ReplaceSel ŃeLXguǉvB
	LPCTSTR lpszText = reinterpret_cast<LPCTSTR>(lParam);
	pEdit->ReplaceSel(lpszText);

	return 1L;
}

HBRUSH CGLOutputDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	if(pWnd->GetDlgCtrlID() == IDC_EDIT_PROMPT){
		// o̓GfBbg{bNX̔wiF Visual Studio ̂悤
		// iǂݎpɂ炸j^ɂB
		pDC->SetBkMode(OPAQUE);
		pDC->SetBkColor(RGB(0xFF, 0xFF, 0xFF));
		return static_cast<HBRUSH>(::GetStockObject(WHITE_BRUSH));
	}
	else{
		return CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	}
}

void CGLOutputDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	RecalcChild();
}

void CGLOutputDlg::RecalcChild()
{
	CWnd* pWnd = GetDlgItem(IDC_EDIT_PROMPT);
	if(!pWnd){
		return;
	}

	CRect rc;
	GetClientRect(rc);
	rc.DeflateRect(5, 5);

	pWnd->MoveWindow(rc);
}
