/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#include "stdafx.h"
#include "fugen.h"
#include "GLNamedCPlaneDlg.h"
#include "ViewCmd/NamedCPlaneTool.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CGLNamedCPlaneDlg::CGLNamedCPlaneDlg(MGNamedCPlaneTool* tool)
: CGLNamedTargetDlg(tool){
}

BEGIN_MESSAGE_MAP(CGLNamedCPlaneDlg, CGLNamedTargetDlg)
END_MESSAGE_MAP()

CString CGLNamedCPlaneDlg::GetInputDlgTitle() const{
	CString str;
	str.LoadString(IDS_INPUT_DLG_TITLE_NAMED_CPLANE);
	return str;
}

CString CGLNamedCPlaneDlg::GetInputDlgLabelSave() const{
	CString str;
	str.LoadString(IDS_INPUT_DLG_LABEL_NAMED_CPLANE_SAVE);
	return str;
}

CString CGLNamedCPlaneDlg::GetInputDlgLabelRename() const{
	CString str;
	str.LoadString(IDS_INPUT_DLG_LABEL_NAMED_CPLANE_RENAME);
	return str;
}

void CGLNamedCPlaneDlg::LoadBitmap(CBitmap& bmp) const{
	bmp.LoadBitmap(IDB_NAMED_CPLANE);
}

MGNamedCPlaneTool* CGLNamedCPlaneDlg::getNamedCPlaneTool(){
	return static_cast<MGNamedCPlaneTool*>(getCmdTool());
}

INamedTargetTool * CGLNamedCPlaneDlg::getNamedTargetTool(){
	return static_cast<INamedTargetTool*>(getNamedCPlaneTool());
}