/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// GLMeshTessDlg.cpp : t@C

#include "stdafx.h"
#include "fugen.h"
#include "GLMeshTessDlg.h"
#include "GLWndMsg.h"
#include "glmeshtessdlg.h"

// CGLMeshTessDlg _CAO

namespace{
	static double CurveTol = -1.;///<Maximum deviation allowed of the approximated polylines from
		///the original boundary curves.
	static double SurfaceTol = -1.;//<Maximum deviation allowed of the approximated facet(triangles) from
				///the original surface.
	static double MaximumEdgeLength = -1.;///<Maximum edge length of the facet(triangles) allowed.
}

IMPLEMENT_DYNAMIC(CGLMeshTessDlg, CDialog)

CGLMeshTessDlg::CGLMeshTessDlg(CWnd* pParent /*=NULL*/)
	 : CDialog(CGLMeshTessDlg::IDD, pParent),
	   m_ctol(CurveTol),
	   m_deviat(SurfaceTol),
	   //m_uvRatio(0),
	   //m_fan_kind(MGCL::SINGLE_TRIANGLE),
	   //m_minimum_triangles(0),
	   m_maxlen(MaximumEdgeLength){
}

CGLMeshTessDlg::~CGLMeshTessDlg(){
	CurveTol=m_ctol;
	SurfaceTol=m_deviat;
	MaximumEdgeLength=m_maxlen;
}

void CGLMeshTessDlg::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_TESSP_CTOLIN, m_ctol);
	DDX_Text(pDX, IDC_TESSP_STOLIN, m_deviat);
	//DDX_Text(pDX, IDC_TESSP_MIN_UVR, m_uvRatio);
	DDX_Text(pDX, IDC_TESSP_MAX_EDGE_LENIN, m_maxlen);
	//DDX_Text(pDX, IDC_TESSP_MINTRI, m_minimum_triangles);
}

BEGIN_MESSAGE_MAP(CGLMeshTessDlg, CDialog)
	ON_BN_CLICKED(IDC_REMESH, OnBnClickedRemesh)
END_MESSAGE_MAP()

BOOL CGLMeshTessDlg::OnInitDialog(){
	if(!CDialog::OnInitDialog()){
		return FALSE;
	}

	UpdateData(FALSE);
	return TRUE;
}

void CGLMeshTessDlg::GetTesselValue(mgTLInputParam& tp){
	UpdateData();

	// eZ[Vp[^ݒ
	tp.set_max_edge_len(m_maxlen);// Op`̕ӂ̍ő̒
	tp.set_crvTol(m_ctol);// ȐƎOp`̍ő̗
	//tp.set_fanKind((MGCL::fan_kind)m_fan_kind);// Op`̎(t@A̓Xgbv)
	//tp.set_max_ratio(m_uvRatio);// Op`̕ӂ̔
	//tp.set_minimum_tri(m_minimum_triangles);// ŏ̎Op`̐
	tp.set_surfTol(m_deviat);// ʂƎOp`̍ő̗
}

void CGLMeshTessDlg::SetTesselValue(const mgTLInputParam& tp){
	// eZ[Vp[^ݒ
	m_maxlen = tp.max_edge_len(); // Op`̕ӂ̍ő̒
	m_ctol = tp.crvTol(); // ȐƎOp`̍ő̗
	//m_fan_kind = tp.fanKind(); // Op`̎(t@A̓Xgbv)
	//m_uvRatio = tp.max_ratio(); // Op`̕ӂ̔
	//m_minimum_triangles = tp.minimum_tri(); // ŏ̎Op`̐
	m_deviat = tp.surfTol(); // ʂƎOp`̍ő̗

	UpdateData(FALSE);
}

void CGLMeshTessDlg::OnBnClickedRemesh(){
	if(!UpdateData()){
		return;
	}

	// e_CAOoRăR}hɃCxg𓊂
	GetParent()->SendMessage(WM_FUGEN_MESH_PARAM_CHANGED);
}
