/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#if !defined(AFX_GLINPUTREALDLG_H__F1F2C868_C43B_47B6_A18D_D4F2764BA315__INCLUDED_)
#define AFX_GLINPUTREALDLG_H__F1F2C868_C43B_47B6_A18D_D4F2764BA315__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"

/////////////////////////////////////////////////////////////////////////////
// CGLInputRealDlg _CAO

class CGLInputRealDlg : public CDialog
{
	CString m_strTitle;
	CString m_strPrompt;
	CSpinButtonCtrl m_spn;
	double m_dValue;

// RXgNV
public:
	CGLInputRealDlg(
		const CString& strTitle = _T(""),
		const CString& strPrompt = _T(""));

// _CAO f[^
	//{{AFX_DATA(CGLInputRealDlg)
	enum { IDD = IDD_INPUT_REAL };
	
	//}}AFX_DATA

	double GetValue() const;
	void SetValue(double dValue);

// I[o[Ch
	//{{AFX_VIRTUAL(CGLInputRealDlg)
protected:
	virtual BOOL OnInitDialog();
	virtual void DoDataExchange(CDataExchange* pDX);
	afx_msg void OnDeltaposSpin(NMHDR* pNMHDR, LRESULT* pResult);
	DECLARE_MESSAGE_MAP()
	//}}AFX_VIRTUAL
};

// px͂̐l̓_CAO
//InputAngleFromDialogue returns true when successfull input.
//When invalid value is input, returns false.
bool InputAngleFromDialogue(
	double& angleDegree,///< initial value is input to display on the dialogue.
					///< on return, updated by the input data from dialogue.
	fugenView* pView,///< When  pView!=nullptr, setFocus is invoked after input.
	double& angleRadian///<Input angle in radian is returned.
);

#endif // !defined(AFX_GLINPUTREALDLG_H__F1F2C868_C43B_47B6_A18D_D4F2764BA315__INCLUDED_)
