/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// GLInputRealDlg.cpp : Cve[V t@C

#include "stdafx.h"
#include "fugen.h"
#include "fugenView.h"
#include "GLInputRealDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLInputRealDlg _CAO

CGLInputRealDlg::CGLInputRealDlg(
	const CString& strTitle,
	const CString& strPrompt)
	 : CDialog(IDD, 0),
	   m_strTitle(strTitle),
	   m_strPrompt(strPrompt)
{
	//{{AFX_DATA_INIT(CGLInputRealDlg)
	m_dValue = 0.0;
	//}}AFX_DATA_INIT
}

void CGLInputRealDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGLInputRealDlg)
	DDX_Text(pDX, IDC_INPUT_REAL_EDIT, m_dValue);
	DDX_Control(pDX, IDC_INPUT_REAL_SPIN, m_spn);
	//}}AFX_DATA_MAP
}

BOOL CGLInputRealDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	if(!m_strTitle.IsEmpty()){
		SetWindowText(m_strTitle);
	}

	if(!m_strPrompt.IsEmpty()){
		SetDlgItemText(IDC_STATIC_PROMPT, m_strPrompt);
	}

	m_spn.SetRange32(1, 100); // L[

	UpdateData(FALSE);
	return TRUE;
}

double CGLInputRealDlg::GetValue() const
{
	return m_dValue;
}

void CGLInputRealDlg::SetValue(double dValue)
{
	m_dValue = MGCL::decimalAlign(dValue);
}

BEGIN_MESSAGE_MAP(CGLInputRealDlg, CDialog)
	//{{AFX_MSG_MAP(CGLInputRealDlg)
	ON_NOTIFY(UDN_DELTAPOS, IDC_INPUT_REAL_SPIN, OnDeltaposSpin)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CGLInputRealDlg::OnDeltaposSpin(NMHDR* pNMHDR, LRESULT* pResult)
{
	*pResult = 0;

	NM_UPDOWN* pUpDown = reinterpret_cast<NM_UPDOWN*>(pNMHDR);
	UINT nIDC =(UINT) pUpDown->hdr.idFrom;
	if(nIDC != IDC_INPUT_REAL_SPIN){
		return;
	}

	if(!UpdateData()){
		return;
	}

	double dValue = m_dValue + pUpDown->iDelta * .1;
	//dValue = (std::max)(dValue, threashold_lower);
	//dValue = (std::min)(dValue, threashold_upper);
	m_dValue = dValue;

	UpdateData(FALSE);
}

// px͂̐l̓_CAO
//InputAngleFromDialogue returns true when successfull input.
//When invalid value is input, returns false.
bool InputAngleFromDialogue(
	double& angleDegree,///< initial value is input to display on the dialogue.
					///< on return, updated by the input data from dialogue.
	fugenView* pView,///< When  pView!=nullptr, setFocus is invoked after input.
	double& angleRadian///<Input angle in radian is returned.
){
	CString title;title.LoadString(IDS_CAPTION_ANGLE);
	CGLInputRealDlg dlg(title);
	dlg.SetValue(angleDegree);
	if(dlg.DoModal()==IDOK){
		if(pView)
			pView->SetFocus();
		angleDegree = dlg.GetValue();
		if(-360<angleDegree && angleDegree<360.){
			angleRadian=MGCL::degree_to_radian(angleDegree);
			// R}hI
			return true;
		}
	}
	return false;
}