/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// GLInputNumberDlg.cpp : Cve[V t@C

#include "stdafx.h"
#include "GLInputNumberDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLInputNumberDlg _CAO

CGLInputNumberDlg::CGLInputNumberDlg(
	const CString& strTitle,
	const CString& strPrompt)
	 : CDialog(IDD, 0),
	   m_strTitle(strTitle),
	   m_strPrompt(strPrompt)
{
	//{{AFX_DATA_INIT(CGLInputNumberDlg)
	m_nValue = 0;
	//}}AFX_DATA_INIT
}

void CGLInputNumberDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGLInputNumberDlg)
	DDX_Text(pDX, IDC_INPUT_NUMBER_EDIT, m_nValue);
	DDX_Control(pDX, IDC_INPUT_NUMBER_SPIN, m_spn);
	//}}AFX_DATA_MAP
}

int CGLInputNumberDlg::GetValue() const{
	return m_nValue;
}

void CGLInputNumberDlg::SetValue(int nValue){
	m_nValue = nValue;
}

BEGIN_MESSAGE_MAP(CGLInputNumberDlg, CDialog)
	//{{AFX_MSG_MAP(CGLInputNumberDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CGLInputNumberDlg::OnInitDialog(){
	CDialog::OnInitDialog();

	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	if(!m_strTitle.IsEmpty()){
		SetWindowText(m_strTitle);
	}

	if(!m_strPrompt.IsEmpty()){
		SetDlgItemText(IDC_STATIC_PROMPT, m_strPrompt);
	}

	int nLower, nUpper;
	m_spn.GetRange32(nLower, nUpper);
	if(nLower > nUpper){
		m_spn.SetRange32(nUpper, nLower);
	}

	UpdateData(FALSE);
	return TRUE;
}
