/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#include "stdafx.h"
#include <dlgs.h> // psh2 QƂꍇ̓RgAEgւׂB
#include "fugen.h"
#include "GLFileDialog.h"
#include "IO/GLFileManager.h"
#include "IO/GLFileExporter.h"
#include "VersionHelpers.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

BEGIN_MESSAGE_MAP(CGLFileDialog, CFileDialog)
	ON_BN_CLICKED(IDC_BUTTON_OPTION, OnBnClickedOption)
END_MESSAGE_MAP()

// RXgN^[
CGLFileDialog::CGLFileDialog(
	BOOL bOpenFileDialog,
	LPCTSTR lpszDefExt,
	LPCTSTR lpszFileName,
	DWORD dwFlags,
	LPCTSTR lpszFilter,
	CWnd* pParentWnd)
	 : CFileDialog(bOpenFileDialog, lpszDefExt, lpszFileName, dwFlags, lpszFilter, pParentWnd)
{
	if(!bOpenFileDialog){
		m_ofn.Flags |= OFN_EXPLORER | OFN_ENABLETEMPLATE;

		// OS̎ނɂăt@CI_CAO𕪂
		// vistaȍ~GetIFileDialogCustomize()Ă
		// XPȑȌꍇ́A܂ŒʂSetTemplate(0, IDD_FILEDIALOG_OPTION)Ă
		// o[W6ȍ~̂̂Avistaȍ~̂̂ɂȂ
		if(IsWindowsXPOrGreater())
			GetIFileDialogCustomize();
		else
			SetTemplate(0, IDD_FILEDIALOG_OPTION);
	}
}

BOOL CGLFileDialog::OnInitDialog()
{
	if(!CFileDialog::OnInitDialog()){
		return FALSE;
	}

	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	if(m_bOpenFileDialog){
		return TRUE;
	}

	// TCY킹

	//CWnd* pWndLabel = GetParent()->GetDlgItem(stc2); // ut@C̎ށvx
	CWnd* pWndCancel = GetParent()->GetDlgItem(IDCANCEL);
	CWnd* pWndOpt = GetDlgItem(IDC_BUTTON_OPTION); // JX^̈́uIvVv{^
	CWnd* pWndPane = pWndOpt->GetParent(); // ł傤
	if(!pWndCancel || !pWndOpt || !pWndPane){
		// Ƃ肠_CAO\悤
		return TRUE;
	}

	CRect rcLabel;
	pWndCancel->GetWindowRect(rcLabel);
	ScreenToClient(rcLabel);

	CRect rcOpt;
	pWndOpt->GetWindowRect(rcOpt);
	ScreenToClient(rcOpt);

	CRect rcPane;
	pWndOpt->GetWindowRect(rcPane);
	ScreenToClient(rcPane);

	// IvV{^𓮂B

	//rcPane.InflateRect(0, 0, rcLabel.left - rcOpt.left, 0);
	rcOpt += CSize(rcLabel.left - rcOpt.left, 0);
	rcOpt.right = rcOpt.left + rcLabel.Width();

	pWndOpt->MoveWindow(rcOpt);
	//pWndPane->MoveWindow(rcPane);

	UpdateOptionButton();

	return TRUE;
}

// ̓pX̌ɗpBMSDN QƁB
BOOL CGLFileDialog::OnFileNameOK()
{
	if(GetFileExt().IsEmpty()){
		// uׂāvƃ^CvȂ̂ŏI
		if(m_ofn.nFilterIndex == m_ofn.nMaxCustFilter){
			AfxMessageBox(IDS_WARNING_EXTENSION);
			return TRUE;
		}
		else{
			// gq𑫂Ă
			// łɓ̃t@CȂǂׂ
			// Ώ㏑Ă悢ǂp҂ɂ˂
			if(!m_bOpenFileDialog){ // ۑ̂Ƃ݂̂̏

				// ̃pX͂炭ʂȂB

				CGLFileManager& fm = CGLFileManager::GetInstance();
				CString ext = GetDesiredExt();
				ASSERT(!ext.IsEmpty());

				CString fileName = GetPathName();

				// gqt
				::PathAddExtension(fileName.GetBuffer(MAX_PATH), ext);
				fileName.ReleaseBuffer();

				CFileFind ff;
				if(ff.FindFile(fileName)){
					CString strMessage;
					strMessage.Format(IDS_PROMPT_OVERWRITE, fileName);
					int nRet = AfxMessageBox(strMessage, MB_YESNO, MB_ICONQUESTION | MB_DEFBUTTON2);
					if(nRet != IDYES){
						return TRUE;
					}
				}
			}
		}
	}
	return FALSE;
}

// R{{bNX̑IωƂɌĂ΂BMSDN QƁB
void CGLFileDialog::OnTypeChange()
{
	UpdateOptionButton();
}

// IvV{^̃Cxgnh[
void CGLFileDialog::OnBnClickedOption()
{
	if(m_bOpenFileDialog){
		return;
	}

	// t@Cۑ̃IvV
	const OPENFILENAME& ofn = GetOFN();
	CWnd* pWndOpt = GetDlgItem(IDC_BUTTON_OPTION);

	CGLFileManager& mgr = CGLFileManager::GetInstance();
	CGLFileExporter* pHandler = mgr.GetExporterFromFilter(
		GetCurrentFilterText());
	ASSERT(pHandler);

	// \
	pHandler->OnSetOption();
}

void CGLFileDialog::UpdateOptionButton()
{
	if(m_bOpenFileDialog){
		return;
	}

	CWnd* pWndOpt = GetDlgItem(IDC_BUTTON_OPTION);
	if(!pWndOpt){
		return;
	}

	CGLFileManager& mgr = CGLFileManager::GetInstance();
	CGLFileExporter* pHandler = mgr.GetExporterFromFilter(
		GetCurrentFilterText());

	// 󋵂ɉăO[AEg
	pWndOpt->EnableWindow(pHandler != 0 && pHandler->HasOption());
}

/// IĂ "AG Files (*.ag)" ̃eLXgԂB
CString CGLFileDialog::GetCurrentFilterText() const
{
	const OPENFILENAME& ofn = GetOFN();
	const int nNullChar = 2 * (ofn.nFilterIndex - 1);
	const TCHAR* pChar = ofn.lpstrFilter;
	for(int nCount = 0; nCount < nNullChar; ++pChar){
		if(*pChar == TCHAR(0)){
			++nCount;
		}
	}
	return CString(pChar);
}

// Igest@C(*.iges;*.igs)
// agt@C(*.ag)
CString CGLFileDialog::GetDesiredExt() const
{
	CString str(GetCurrentFilterText());
	int nStart = str.Find(_T("(*."));
	if(nStart == -1){
		return _T(".mgl");
	}
	// (* XLbvB
	nStart += 2;

	// Z~RɃeXgB
	int nEnd = str.Find(_T(";"), nStart);
	if(nEnd != -1){
		return str.Mid(nStart, nEnd - nStart);
	}

	// ʏIeXgB
	nEnd = str.Find(_T(")"), nStart);
	if(nEnd != -1){
		return str.Mid(nStart, nEnd - nStart);
	}

	return _T(".mgl");
}
