/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file GLExtendDlgBase.cpp
 * @brief NX CGLExtendDlgBase ̎
 */
#include "stdafx.h"
#include "fugen.h"
#include "GLExtendDlgBase.h"
#include "fugenDoc.h"
#include "Common/CommandBase.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CGLExtendDlgBase::CGLExtendDlgBase(
	MGCommandBase* tool
): mgModelessDialogue(tool),
  m_dLength(10.0), // OnInitDialog œKXZbg
  m_dVary(0.0) // OnInitDialog œKXZbg
{
}

void CGLExtendDlgBase::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);

	DDX_Text(pDX, IDC_EXT_LEN, m_dLength);
	DDV_MinMaxDouble(pDX, m_dLength, 0.0, DBL_MAX);
	DDX_Control(pDX, IDC_SPIN_LEN, m_spnLength);

	DDX_Text(pDX, IDC_CURVA_VARY, m_dVary);
	DDV_MinMaxDouble(pDX, m_dVary, 0.0, 1.0);
	DDX_Control(pDX, IDC_SPIN_VARY, m_spnVary);
}

BOOL CGLExtendDlgBase::OnInitDialog(){
	if(!mgModelessDialogue::OnInitDialog()){
		return FALSE;
	}

	// Xs{^̃WZbg
	m_spnLength.SetRange32(0, 100);
	m_spnVary.SetRange32(0, 10);
	return TRUE;
}

void CGLExtendDlgBase::SetLength(double dLength){
	m_dLength = MGCL::decimalAlign(dLength);
}

void CGLExtendDlgBase::SetVary(double dVary){
	ASSERT(0. <= dVary && dVary <= 1.);
	m_dVary = dVary;
}

BEGIN_MESSAGE_MAP(CGLExtendDlgBase, mgModelessDialogue)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_LEN, OnDeltaposSpin)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_VARY, OnDeltaposSpin)
	ON_BN_CLICKED(IDC_BUTTON_PREVIEW, OnPreview)
END_MESSAGE_MAP()

// CGLExtendDlgBase bZ[W nh

void CGLExtendDlgBase::OnPreview(){
	if(!UpdateData())
		return;
	UpdateView();
}

// Xs{^
void CGLExtendDlgBase::OnDeltaposSpin(NMHDR* pNM, LRESULT* pResult){
	NM_UPDOWN* pUpDown = reinterpret_cast<NM_UPDOWN*>(pNM);
	UINT nIDC = (UINT)(pUpDown->hdr.idFrom);

	switch(nIDC){
	case IDC_SPIN_LEN:
		{
			*pResult = 0;
			if(!UpdateData()){ // GfBbg{bNX (m_dLength) XV
				return;
			}

			double dLenNew = m_dLength + pUpDown->iDelta; // + 1.0
			m_dLength = (std::max)(dLenNew, 0.0);

			UpdateData(FALSE);
			UpdateView();
		}
		break;
	case IDC_SPIN_VARY:
		// OŃCNg
		{
			*pResult = 0;
			if(!UpdateData()){ // GfBbg{bNX (m_dVary) XV
				return;
			}
			double dVaryNew = m_dVary + pUpDown->iDelta * .1; // + 0.1
			dVaryNew = (std::max)(dVaryNew, 0.0);
			dVaryNew = (std::min)(dVaryNew, 1.0);
			m_dVary = dVaryNew;
			UpdateData(FALSE);
			UpdateView();
		}
		break;
	default:
		*pResult = 1;
		break;
	}
}
