/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// GLDisplayPropPane.cpp : Cve[V t@C

#include "stdafx.h"
#include "fugen.h"
#include "fugenDoc.h"
#include "GLDisplayPropPane.h"
#include "Misc/UserPreference.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLDisplayPropPane _CAO

CGLDisplayPropPane::CGLDisplayPropPane(fugenDoc* pDoc)
:CGLPropPane(pDoc){
	//{{AFX_DATA_INIT(CGLDisplayPropPane)
	//}}AFX_DATA_INIT
}

void CGLDisplayPropPane::DoDataExchange(CDataExchange* pDX)
{
	CGLPropPane::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGLDisplayPropPane)
	DDX_Control(pDX, IDC_BUTTON_BKGND, m_btnBkgnd);
	DDX_Control(pDX, IDC_BUTTON_AMBIENT, m_btnAmbient);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGLDisplayPropPane, CGLPropPane)
	//{{AFX_MSG_MAP(CGLDisplayPropPane)
	ON_BN_CLICKED(IDC_BUTTON_AMBIENT, OnButtonAmbient)
	ON_BN_CLICKED(IDC_BUTTON_BKGND, OnButtonBkgnd)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGLDisplayPropPane bZ[W nh

void CGLDisplayPropPane::OnButtonAmbient()
{
	m_btnAmbient.ChangeColor();
}

void CGLDisplayPropPane::OnButtonBkgnd()
{
	m_btnBkgnd.ChangeColor();
}

void CGLDisplayPropPane::LoadUserProf(){
	UserPreference& pref = UserPreference::getInstance();

	m_btnBkgnd.SetColor(pref.GetIntValue(upv_Display_RenderingViewport_BackGround, UserPreference::CurrentValue));
	m_btnAmbient.SetColor(pref.GetIntValue(upv_Display_RenderingViewport_Ambient, UserPreference::CurrentValue));

	UpdateData(FALSE);
}

BOOL CGLDisplayPropPane::UpdateUserProf(){
	if(UpdateData()){
	UserPreference& pref = UserPreference::getInstance();

	pref.SetIntValue(upv_Display_RenderingViewport_BackGround, m_btnBkgnd.GetColor());
	pref.SetIntValue(upv_Display_RenderingViewport_Ambient, m_btnAmbient.GetColor());

	return TRUE;
	}
	return FALSE;
}

void CGLDisplayPropPane::ResetToDefaultUserProf(){
	UserPreference& pref = UserPreference::getInstance();

	m_btnBkgnd.SetColor(pref.GetIntValue(upv_Display_RenderingViewport_BackGround, UserPreference::DefaultValue));
	m_btnAmbient.SetColor(pref.GetIntValue(upv_Display_RenderingViewport_Ambient, UserPreference::DefaultValue));

	UpdateData(FALSE);
}

void CGLDisplayPropPane::LoadDocContext(){
	ASSERT(FALSE);
}

BOOL CGLDisplayPropPane::UpdateDocContext(){
	ASSERT(FALSE);
	return FALSE;
}

void CGLDisplayPropPane::ResetToDefaultDocContext(){
	ASSERT(FALSE);
}
